/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

public class OpenCsvEncoder {
    private int lineNumber;
    private String eolSymbols = "\r\n";
    private int delimiter = 44;
    private char quote = (char)34;
    private boolean surroundingSpacesNeedQuotes = false;
    private QuoteMode quoteMode = csvColumn -> false;

    public String encode(String input) {
        boolean quotesRequiredForSurroundingSpaces;
        StringBuilder currentColumn = new StringBuilder();
        this.processInput(input, currentColumn);
        boolean quotesRequiredForMode = this.quoteMode.quotesRequired(input);
        boolean bl = quotesRequiredForSurroundingSpaces = this.surroundingSpacesNeedQuotes && input.length() > 0 && (input.charAt(0) == ' ' || input.charAt(input.length() - 1) == ' ');
        if (quotesRequiredForMode || quotesRequiredForSurroundingSpaces) {
            currentColumn.insert(0, this.quote).append(this.quote);
        }
        return currentColumn.toString();
    }

    private void processInput(String input, StringBuilder currentColumn) {
        boolean skipNewline = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (skipNewline) {
                skipNewline = this.handleSkipNewline(c);
                continue;
            }
            if (this.isDelimiterOrQuote(c, this.delimiter, this.quote)) {
                this.processDelimiterOrQuote(c, currentColumn, this.quote);
                continue;
            }
            if (this.isCarriageReturnOrNewline(c)) {
                this.processCarriageReturnOrNewline(currentColumn);
                if (c != '\r') continue;
                skipNewline = true;
                continue;
            }
            currentColumn.append(c);
        }
    }

    private boolean handleSkipNewline(char c) {
        return c != '\n';
    }

    private boolean isDelimiterOrQuote(char c, int delimiter, char quote) {
        return c == delimiter || c == quote;
    }

    private boolean processDelimiterOrQuote(char c, StringBuilder currentColumn, char quote) {
        if (c == quote) {
            currentColumn.append("\\");
        }
        currentColumn.append(c);
        return true;
    }

    private boolean isCarriageReturnOrNewline(char c) {
        return c == '\r' || c == '\n';
    }

    private boolean processCarriageReturnOrNewline(StringBuilder currentColumn) {
        currentColumn.append(this.eolSymbols);
        ++this.lineNumber;
        return true;
    }

    public static interface QuoteMode {
        public boolean quotesRequired(String var1);
    }
}

