/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.app.license;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.check.mapper.AbstractMapper;
import com.atlassian.migration.agent.service.check.app.license.AppLicenseChecker;
import com.atlassian.migration.agent.service.check.app.license.AppLicenseDto;
import java.util.Collections;
import java.util.List;

public class AppLicenseMapper
extends AbstractMapper {
    private static final String SUCCESS_DESCRIPTION = "All apps meet cloud license check requirements";
    private static final String RUNNING_DESCRIPTION = "Checking cloud license of all apps";
    private static final String EXECUTION_ERROR_DESCRIPTION = "We couldn't complete the cloud license check for apps";
    private static final String ERROR_OR_WARNING_DESCRIPTION = "Some apps need a cloud license update";
    private static final String EXECUTION_ERROR_LONG_DESCRIPTION = "Retry the check. If the problem persists, contact Atlassian Support.";

    protected void inject(CheckResultDto dto, CheckResult checkResult) {
        List<AppLicenseDto> appsWithInactiveLicense;
        switch (dto.getStatus()) {
            case SUCCESS: {
                dto.setDescription(SUCCESS_DESCRIPTION);
                break;
            }
            case WARNING: 
            case ERROR: {
                dto.setDescription(ERROR_OR_WARNING_DESCRIPTION);
                dto.setStatus(Status.WARNING);
                break;
            }
            case RUNNING: {
                dto.setDescription(RUNNING_DESCRIPTION);
                break;
            }
            case EXECUTION_ERROR: {
                dto.setStatus(Status.WARNING);
                dto.setDescription(EXECUTION_ERROR_DESCRIPTION);
                dto.setNumberOfOccurrences(Integer.valueOf(1));
                CheckDetailsDto details = new CheckDetailsDto();
                details.setLongDescription(EXECUTION_ERROR_LONG_DESCRIPTION);
                details.setListOfOccurrences(Collections.emptyList());
                dto.setDetails(details);
                return;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status.");
            }
        }
        if (checkResult != null && !(appsWithInactiveLicense = AppLicenseChecker.retrieveAppsNoLicenseViolations(checkResult.details)).isEmpty()) {
            CheckDetailsDto details = new CheckDetailsDto();
            dto.setNumberOfOccurrences(Integer.valueOf(appsWithInactiveLicense.size()));
            details.setListOfOccurrences(appsWithInactiveLicense);
            dto.setDetails(details);
        }
    }
}

