/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessment;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentWithNesting;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MacrosAssessmentPerSpace {
    @JsonProperty
    private final long spaceId;
    @JsonProperty
    private final long uniqueContentCount;
    @JsonProperty
    private final String spaceUrl;
    @JsonProperty
    private final Set<MacroAssessment> notAvailableMacros;
    @JsonProperty
    private final Set<MacroAssessment> differentMacros;
    @JsonProperty
    private final Set<MacroAssessmentWithNesting> nestedMacros;

    private static long uniqueContentCount(Set<MacroAssessment> notAvailableMacros, Set<MacroAssessment> differentMacros, Set<MacroAssessmentWithNesting> nestedMacros) {
        return Stream.concat(Stream.concat(notAvailableMacros.stream(), differentMacros.stream()), nestedMacros.stream()).flatMap(macroAssessment -> macroAssessment.getContentUrls().stream()).distinct().count();
    }

    @JsonCreator
    public MacrosAssessmentPerSpace(@JsonProperty(value="spaceId") long spaceId, @JsonProperty(value="spaceUrl") String spaceUrl, @JsonProperty(value="notAvailableMacros") Set<MacroAssessment> notAvailableMacros, @JsonProperty(value="differentMacros") Set<MacroAssessment> differentMacros, @JsonProperty(value="nestedMacros") Set<MacroAssessmentWithNesting> nestedMacros) {
        this.spaceId = spaceId;
        this.spaceUrl = spaceUrl;
        this.notAvailableMacros = notAvailableMacros;
        this.differentMacros = differentMacros;
        this.nestedMacros = nestedMacros;
        this.uniqueContentCount = MacrosAssessmentPerSpace.uniqueContentCount(notAvailableMacros, differentMacros, nestedMacros);
    }

    @Generated
    public long getSpaceId() {
        return this.spaceId;
    }

    @Generated
    public long getUniqueContentCount() {
        return this.uniqueContentCount;
    }

    @Generated
    public String getSpaceUrl() {
        return this.spaceUrl;
    }

    @Generated
    public Set<MacroAssessment> getNotAvailableMacros() {
        return this.notAvailableMacros;
    }

    @Generated
    public Set<MacroAssessment> getDifferentMacros() {
        return this.differentMacros;
    }

    @Generated
    public Set<MacroAssessmentWithNesting> getNestedMacros() {
        return this.nestedMacros;
    }

    @Generated
    public String toString() {
        return "MacrosAssessmentPerSpace(spaceId=" + this.getSpaceId() + ", uniqueContentCount=" + this.getUniqueContentCount() + ", spaceUrl=" + this.getSpaceUrl() + ", notAvailableMacros=" + this.getNotAvailableMacros() + ", differentMacros=" + this.getDifferentMacros() + ", nestedMacros=" + this.getNestedMacros() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MacrosAssessmentPerSpace)) {
            return false;
        }
        MacrosAssessmentPerSpace other = (MacrosAssessmentPerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSpaceId() != other.getSpaceId()) {
            return false;
        }
        if (this.getUniqueContentCount() != other.getUniqueContentCount()) {
            return false;
        }
        String this$spaceUrl = this.getSpaceUrl();
        String other$spaceUrl = other.getSpaceUrl();
        if (this$spaceUrl == null ? other$spaceUrl != null : !this$spaceUrl.equals(other$spaceUrl)) {
            return false;
        }
        Set<MacroAssessment> this$notAvailableMacros = this.getNotAvailableMacros();
        Set<MacroAssessment> other$notAvailableMacros = other.getNotAvailableMacros();
        if (this$notAvailableMacros == null ? other$notAvailableMacros != null : !((Object)this$notAvailableMacros).equals(other$notAvailableMacros)) {
            return false;
        }
        Set<MacroAssessment> this$differentMacros = this.getDifferentMacros();
        Set<MacroAssessment> other$differentMacros = other.getDifferentMacros();
        if (this$differentMacros == null ? other$differentMacros != null : !((Object)this$differentMacros).equals(other$differentMacros)) {
            return false;
        }
        Set<MacroAssessmentWithNesting> this$nestedMacros = this.getNestedMacros();
        Set<MacroAssessmentWithNesting> other$nestedMacros = other.getNestedMacros();
        return !(this$nestedMacros == null ? other$nestedMacros != null : !((Object)this$nestedMacros).equals(other$nestedMacros));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MacrosAssessmentPerSpace;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $spaceId = this.getSpaceId();
        result = result * 59 + (int)($spaceId >>> 32 ^ $spaceId);
        long $uniqueContentCount = this.getUniqueContentCount();
        result = result * 59 + (int)($uniqueContentCount >>> 32 ^ $uniqueContentCount);
        String $spaceUrl = this.getSpaceUrl();
        result = result * 59 + ($spaceUrl == null ? 43 : $spaceUrl.hashCode());
        Set<MacroAssessment> $notAvailableMacros = this.getNotAvailableMacros();
        result = result * 59 + ($notAvailableMacros == null ? 43 : ((Object)$notAvailableMacros).hashCode());
        Set<MacroAssessment> $differentMacros = this.getDifferentMacros();
        result = result * 59 + ($differentMacros == null ? 43 : ((Object)$differentMacros).hashCode());
        Set<MacroAssessmentWithNesting> $nestedMacros = this.getNestedMacros();
        result = result * 59 + ($nestedMacros == null ? 43 : ((Object)$nestedMacros).hashCode());
        return result;
    }
}

