/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.entity.GuardrailsResponse;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.guardrails.CpuStatsCalculator;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentService;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentStore;
import com.atlassian.migration.agent.store.guardrails.AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseStore;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseType;
import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.QueryResult;
import com.atlassian.migration.agent.store.jpa.impl.DialectResolver;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.persistence.PersistenceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class InstanceAssessmentService
implements JobRunner {
    private final List<AssessmentQuery> queryList;
    private static final Logger log = ContextLoggerFactory.getLogger(InstanceAssessmentService.class);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.confluence.migration.guardrails.InstanceAssessmentService");
    private static final String DEFAULT_NODE = "defaultClusterNode";
    private static final String SERVER_NODE = "serverNode";
    private final SchedulerService schedulerService;
    private final Map<QueryIds, AssessmentQuery> queryMap;
    protected final Map<DbType, List<QueryIds>> queriesToSkipPerDBMap;
    private final DialectResolver dialectResolver;
    private final GuardrailsResponseGroupStore guardRailsResponseGroupStore;
    private final GuardrailsResponseStore guardrailsResponseStore;
    private final ClusterInformationService clusterInformationService;
    private final PluginTransactionTemplate ptx;
    private final MacroAssessmentService macroAssessmentService;
    private final MacroAssessmentStore macroAssessmentStore;

    public InstanceAssessmentService(List<AssessmentQuery> queryList, SchedulerService schedulerService, DialectResolver dialectResolver, GuardrailsResponseGroupStore guardRailsResponseGroupStore, GuardrailsResponseStore guardrailsResponseStore, ClusterInformationService clusterInformationService, PluginTransactionTemplate ptx, MacroAssessmentService macroAssessmentService, MacroAssessmentStore macroAssessmentStore) {
        this.queryList = queryList;
        this.schedulerService = schedulerService;
        this.dialectResolver = dialectResolver;
        this.guardRailsResponseGroupStore = guardRailsResponseGroupStore;
        this.guardrailsResponseStore = guardrailsResponseStore;
        this.clusterInformationService = clusterInformationService;
        this.ptx = ptx;
        this.macroAssessmentService = macroAssessmentService;
        this.macroAssessmentStore = macroAssessmentStore;
        this.queryMap = new HashMap<QueryIds, AssessmentQuery>();
        this.queriesToSkipPerDBMap = new EnumMap<DbType, List<QueryIds>>(DbType.class);
        this.populateQueryMap();
        this.populateQueriesToSkipPerDBMap();
    }

    private void populateQueryMap() {
        for (AssessmentQuery query : this.queryList) {
            query.queryIds().forEach(id -> this.queryMap.put((QueryIds)((Object)id), query));
        }
    }

    @VisibleForTesting
    protected void populateQueriesToSkipPerDBMap() {
    }

    public List<String> executeAllQueries() {
        return this.queryList.stream().flatMap(this::executeQueryForL1).collect(Collectors.toList());
    }

    private Stream<String> executeQueryForL1(AssessmentQuery assessmentQuery) {
        return assessmentQuery.executeAll().entrySet().stream().map(entry -> ((QueryIds)((Object)((Object)entry.getKey()))).name() + ":" + ((QueryResult)entry.getValue()).generateResult());
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        try {
            CpuStatsCalculator calculator = CpuStatsCalculator.createCalculator();
            String jobId = request.getJobId().toString();
            String nodeId = this.getNodeId();
            GuardrailsResponseGroup responseGroup = new GuardrailsResponseGroup(jobId, nodeId);
            String responseGroupId = this.ptx.write(() -> this.guardRailsResponseGroupStore.createResponseGroup(responseGroup));
            log.info("Running job for jobId:{}", (Object)jobId);
            BooleanSupplier isAssessmentCanceled = this.isCanceledSupplier(jobId);
            this.executeGuardrailsQueries(responseGroup, isAssessmentCanceled, calculator);
            this.executeMacroAssessment(isAssessmentCanceled, calculator);
            GuardrailsResponseGroup rg = this.guardRailsResponseGroupStore.getResponseGroupByJobId(jobId);
            if (!rg.isCanceled()) {
                this.ptx.write(() -> this.guardRailsResponseGroupStore.completeResponseGroup(responseGroupId));
                log.info("Running jobs completed for jobId:{}", (Object)request.getJobId());
            }
        }
        catch (Exception e) {
            log.error("Failed to run job - jobId:" + request.getJobId() + "for nodeId: " + this.getNodeId(), (Throwable)e);
            JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success((String)"");
    }

    private void executeMacroAssessment(BooleanSupplier isAssessmentCanceled, CpuStatsCalculator calculator) throws IOException {
        log.info("Macro assessment started");
        calculator.start();
        MacroAssessmentResult assessment = this.macroAssessmentService.assess(isAssessmentCanceled);
        CpuStatsCalculator.CpuStats cpuStats = calculator.finish();
        assessment.addExecutionStats(cpuStats.duration.toMillis(), cpuStats.load);
        log.info("Macro assessment finished, storing the results");
        this.macroAssessmentStore.store(assessment, LocalDate.now());
        log.info("Macro assessment stored");
    }

    public List<GuardrailsResponse> getExamples() {
        GuardrailsResponseGroup responseGroup = new GuardrailsResponseGroup("ID", this.getNodeId());
        List queriesToSkip = this.queriesToSkipPerDBMap.getOrDefault((Object)this.dialectResolver.getDbType(), Collections.emptyList());
        return this.queryList.stream().flatMap(q -> this.execute((AssessmentQuery)q, responseGroup, queriesToSkip, () -> false, AssessmentQuery::examples, CpuStatsCalculator.createCalculator())).collect(Collectors.toList());
    }

    private void executeGuardrailsQueries(GuardrailsResponseGroup responseGroup, BooleanSupplier cancelSupplier, CpuStatsCalculator cpuLoadBeforeAssessment) {
        List queriesToSkip = this.queriesToSkipPerDBMap.getOrDefault((Object)this.dialectResolver.getDbType(), Collections.emptyList());
        this.queryList.forEach(query -> {
            List guardrailsResponses = this.execute((AssessmentQuery)query, responseGroup, queriesToSkip, cancelSupplier, AssessmentQuery::executeAll, cpuLoadBeforeAssessment).collect(Collectors.toList());
            this.ptx.write(() -> guardrailsResponses.forEach(this.guardrailsResponseStore::createGuardrailsResponse));
        });
    }

    public Stream<GuardrailsResponse> execute(AssessmentQuery query, GuardrailsResponseGroup responseGroup, List<QueryIds> queriesToSkip, BooleanSupplier cancelSupplier, Function<AssessmentQuery, Map<QueryIds, QueryResult>> executor, CpuStatsCalculator cpuStatsCalculator) {
        GuardrailsResponse guardrailsResponse = new GuardrailsResponse();
        guardrailsResponse.setResponseGroupId(responseGroup.getId());
        guardrailsResponse.setGuardrailsResponseType(GuardrailsResponseType.L1);
        guardrailsResponse.setResponseGroup(responseGroup);
        Set<QueryIds> queryIds = query.queryIds();
        EnumMap<QueryIds, QueryResult> results = new EnumMap<QueryIds, QueryResult>(QueryIds.class);
        if (cancelSupplier.getAsBoolean()) {
            log.info("Query with queryId:{} canceled", queryIds);
            guardrailsResponse.setQueryResponse("");
            guardrailsResponse.setSuccess(false);
            guardrailsResponse.setQueryStatus(InstanceAssessmentStatus.CANCELED.toString());
        } else if (queryIds.stream().anyMatch(queriesToSkip::contains)) {
            log.info("Skipping query with queryId:{}", queryIds);
            guardrailsResponse.setQueryResponse("");
            guardrailsResponse.setSuccess(true);
            guardrailsResponse.setQueryStatus(InstanceAssessmentStatus.SKIPPED.toString());
        } else {
            cpuStatsCalculator.start();
            try {
                results.putAll(executor.apply(query));
                CpuStatsCalculator.CpuStats cpuStats = cpuStatsCalculator.finish();
                guardrailsResponse.setSuccess(true);
                guardrailsResponse.setQueryCpuLoad(cpuStats.load);
                guardrailsResponse.setQueryDuration(cpuStats.duration.toMillis());
                log.info("Finished executing query with queryId:{} for jobID:{} in :{}ms", new Object[]{queryIds, responseGroup.getJobId(), cpuStats.duration.toMillis()});
            }
            catch (Exception e) {
                CpuStatsCalculator.CpuStats cpuStats = cpuStatsCalculator.finish();
                guardrailsResponse.setQueryResponse("");
                guardrailsResponse.setSuccess(false);
                guardrailsResponse.setQueryCpuLoad(cpuStats.load);
                guardrailsResponse.setQueryDuration(cpuStats.duration.toMillis());
                log.error("Error while executing query for queryID: " + queryIds, (Throwable)e);
            }
            String queryStatus = InstanceAssessmentStatus.FAILED.toString();
            if (guardrailsResponse.isSuccess()) {
                queryStatus = InstanceAssessmentStatus.COMPLETE.toString();
            }
            guardrailsResponse.setQueryStatus(queryStatus);
        }
        return queryIds.stream().map(id -> guardrailsResponse.toBuilder().queryId(id.name()).queryResponse(Optional.ofNullable(results.get(id)).map(QueryResult::generateResult).orElse("")).build());
    }

    private String getNodeId() {
        return Optional.ofNullable(this.clusterInformationService.getCurrentNodeId()).orElse(DEFAULT_NODE);
    }

    public String executeQuery(QueryIds queryId) {
        return this.queryMap.get((Object)queryId).executeAll().get((Object)queryId).generateResult();
    }

    public long getJobProgress(String jobId) {
        log.info("Job running for jobId:{}", (Object)jobId);
        int numberOfQueries = this.queryList.size();
        Long completedQueries = this.guardrailsResponseStore.getNumberOfQueries(jobId);
        log.info("Queries :{} is :{}", (Object)completedQueries, (Object)numberOfQueries);
        long progress = numberOfQueries == 0 ? 0L : completedQueries * 100L / (long)numberOfQueries;
        log.info("Progress for jobId:{} is :{}", (Object)jobId, (Object)progress);
        return progress;
    }

    public Set<JobDetails> getActiveJobs() {
        return Collections.unmodifiableSet(new HashSet(this.schedulerService.getJobsByJobRunnerKey(RUNNER_KEY)));
    }

    public void scheduleJob() throws SchedulerServiceException {
        JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withParameters(Collections.singletonMap(SERVER_NODE, this.getNodeId())).withSchedule(Schedule.runOnce(null)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER));
        log.info("Job scheduled with id:{} for  nodeId:{}", (Object)jobId, (Object)this.getNodeId());
    }

    private BooleanSupplier isCanceledSupplier(final String jobId) {
        return new BooleanSupplier(){
            boolean canceled = false;

            @Override
            public boolean getAsBoolean() {
                this.canceled = this.canceled || InstanceAssessmentService.this.isCanceled(jobId);
                return this.canceled;
            }
        };
    }

    private boolean isCanceled(String jobId) {
        try {
            GuardrailsResponseGroup responseGroup = this.guardRailsResponseGroupStore.getResponseGroupByJobId(jobId);
            return responseGroup != null && responseGroup.isCanceled();
        }
        catch (PersistenceException e) {
            return false;
        }
    }

    public void cancelAssessmentCollection() {
        this.ptx.write(() -> {
            Optional<GuardrailsResponseGroup> lastJob = this.guardRailsResponseGroupStore.findLast();
            lastJob.ifPresent(job -> this.guardRailsResponseGroupStore.cancelGuardrails(job.getId()));
        });
        List jobDetails = this.schedulerService.getJobsByJobRunnerKey(RUNNER_KEY);
        jobDetails.stream().map(JobDetails::getJobId).forEach(arg_0 -> ((SchedulerService)this.schedulerService).unscheduleJob(arg_0));
        log.info("Instance assessment control is canceled.");
    }
}

