/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.dto.UserDomainRuleDto;
import com.atlassian.migration.agent.entity.DomainRuleBehaviour;
import com.atlassian.migration.agent.model.UserDomainRuleRecord;
import com.atlassian.migration.agent.service.email.CsvDomainUploadStatus;
import com.atlassian.migration.agent.service.impl.CsvReaderService;
import com.atlassian.migration.agent.service.impl.UserDomainService;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.opencsv.CSVReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedDomainCsvReaderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrustedDomainCsvReaderService.class);
    private final UserDomainService userDomainService;
    private final CsvReaderService csvReaderService = new CsvReaderService();

    public TrustedDomainCsvReaderService(UserDomainService userDomainService) {
        this.userDomainService = userDomainService;
    }

    public CsvDomainUploadStatus processDomainsCsv(FilePart file) {
        BufferedInputStream inputStream;
        ArrayList<UserDomainRuleRecord> rules = new ArrayList<UserDomainRuleRecord>();
        ArrayList<String> errorRecords = new ArrayList<String>();
        if (!file.getContentType().equalsIgnoreCase("text/csv") || !file.getName().toLowerCase().endsWith(".csv")) {
            return CsvDomainUploadStatus.builder().result(CsvDomainUploadStatus.Result.RECORD_FAILED).errorMessage("Invalid file type").build();
        }
        try {
            inputStream = new BufferedInputStream(file.getInputStream());
            ((InputStream)inputStream).mark(1);
        }
        catch (IOException e) {
            return CsvDomainUploadStatus.builder().result(CsvDomainUploadStatus.Result.RECORD_FAILED).errorMessage(e.getLocalizedMessage()).build();
        }
        try (CSVReader tempreader = this.csvReaderService.getCsvReaderForInputStream(inputStream);){
            String[] nextLine;
            Object[] tempheader = tempreader.readNext();
            char delimiter = this.detectDelimiter(Arrays.toString(tempheader));
            ((InputStream)inputStream).reset();
            CSVReader reader = this.csvReaderService.getCsvReaderForInputStreamWithDelimiter(inputStream, delimiter);
            String[] header = reader.readNext();
            for (int i = 0; i < header.length; ++i) {
                header[i] = header[i].trim();
            }
            int lineNumber = 2;
            while ((nextLine = reader.readNext()) != null) {
                UserDomainRuleRecord userDomainRuleRecord = this.parseCsvLine(nextLine, 0);
                if (userDomainRuleRecord != null) {
                    rules.add(userDomainRuleRecord);
                } else {
                    errorRecords.add("Message= [The Domain name should not be blank] row=" + lineNumber + ", column=1");
                }
                ++lineNumber;
            }
        }
        catch (Exception e) {
            return CsvDomainUploadStatus.builder().result(CsvDomainUploadStatus.Result.RECORD_FAILED).records(rules.size()).errorMessage(e.getLocalizedMessage()).build();
        }
        CsvDomainUploadStatus status = this.validate(rules, errorRecords);
        return status.getResult() == CsvDomainUploadStatus.Result.SUCCESS ? this.recordTrustedDomainsData(rules) : status;
    }

    private UserDomainRuleRecord parseCsvLine(String[] csvLine, int rowNumber) {
        ArrayList<String> errorRecords = new ArrayList<String>();
        if (csvLine.length == 0) {
            errorRecords.add("Message= [Empty CSV line] row=" + rowNumber);
            return null;
        }
        for (int i = 0; i < csvLine.length; ++i) {
            csvLine[i] = csvLine[i].trim();
        }
        String domain = "";
        if (csvLine[0] != null) {
            domain = csvLine[0].trim();
        }
        if (StringUtils.isBlank((CharSequence)domain)) {
            errorRecords.add("Message= [Could not parse 'null' as a domain name] row=" + rowNumber + ", column=1");
            return null;
        }
        String decision = "";
        if (csvLine.length > 1 && csvLine[1] != null) {
            decision = csvLine[1].trim();
        }
        UserDomainRuleRecord userDomainRuleRecord = new UserDomainRuleRecord();
        userDomainRuleRecord.setDomain(domain);
        userDomainRuleRecord.setDecision(decision);
        return userDomainRuleRecord;
    }

    private char detectDelimiter(String line) {
        if (line.contains(",")) {
            return ',';
        }
        if (line.contains(";")) {
            return ';';
        }
        if (line.contains("\t")) {
            return '\t';
        }
        return ',';
    }

    private CsvDomainUploadStatus validate(List<UserDomainRuleRecord> rules, List<String> errorRecords) {
        List<String> validDomains = this.getValidDomainNames();
        CsvDomainUploadStatus.CsvDomainUploadStatusBuilder uploadStatusBuilder = CsvDomainUploadStatus.builder();
        uploadStatusBuilder.records(rules.size());
        uploadStatusBuilder.result(CsvDomainUploadStatus.Result.RECORD_VALIDATION_FAILED);
        if (!errorRecords.isEmpty()) {
            String errorMessage = String.join((CharSequence)"\n", errorRecords);
            log.warn(errorMessage);
            return uploadStatusBuilder.errorMessage(errorMessage).result(CsvDomainUploadStatus.Result.RECORD_FAILED).records(errorRecords.size()).build();
        }
        if (!this.verifyFileIncludesCorrectNumberOfDomains(rules, validDomains)) {
            return uploadStatusBuilder.errorMessage("incorrect-domain-count").build();
        }
        if (!this.verifyFileIncludesOnlyValidDomains(rules, validDomains)) {
            return uploadStatusBuilder.errorMessage("invalid-domain-names").build();
        }
        if (!this.verifyFileIncludesOnlyValidRules(rules)) {
            return uploadStatusBuilder.errorMessage("invalid-rules").build();
        }
        return uploadStatusBuilder.result(CsvDomainUploadStatus.Result.SUCCESS).build();
    }

    private CsvDomainUploadStatus recordTrustedDomainsData(List<UserDomainRuleRecord> records) {
        CsvDomainUploadStatus.CsvDomainUploadStatusBuilder uploadStatusBuilder = CsvDomainUploadStatus.builder();
        uploadStatusBuilder.records(records.size());
        try {
            this.userDomainService.createAllDomainRules(records.stream().map(this::toUserDomainRuleDTO).filter(domainRule -> domainRule.getRule() != DomainRuleBehaviour.NO_DECISION_MADE).collect(Collectors.toList()));
            uploadStatusBuilder.result(CsvDomainUploadStatus.Result.SUCCESS);
        }
        catch (Exception e) {
            uploadStatusBuilder.result(CsvDomainUploadStatus.Result.RECORD_INSERT_FAILED).errorMessage(e.getLocalizedMessage());
            log.error("Failed to save trusted domains from CSV", (Throwable)e);
        }
        return uploadStatusBuilder.build();
    }

    private UserDomainRuleDto toUserDomainRuleDTO(UserDomainRuleRecord domainRuleRecord) {
        return new UserDomainRuleDto(domainRuleRecord.getDomain(), StringUtils.isBlank((CharSequence)domainRuleRecord.getDecision()) ? DomainRuleBehaviour.NO_DECISION_MADE : DomainRuleBehaviour.valueOf(domainRuleRecord.getDecision().toUpperCase()));
    }

    private List<String> getValidDomainNames() {
        List<String> storedBlockedDomains = this.userDomainService.getBlockedDomainsFromStore();
        return this.userDomainService.getUserDomainCounts().stream().map(domainCount -> domainCount.getDomainName().toLowerCase()).filter(domainName -> !storedBlockedDomains.contains(domainName)).distinct().collect(Collectors.toList());
    }

    private boolean verifyFileIncludesCorrectNumberOfDomains(List<UserDomainRuleRecord> rules, List<String> validDomains) {
        return rules.size() == validDomains.size();
    }

    private boolean verifyFileIncludesOnlyValidDomains(List<UserDomainRuleRecord> domainRuleRecords, List<String> validDomains) {
        return domainRuleRecords.stream().map(UserDomainRuleRecord::getDomain).allMatch(validDomains::contains);
    }

    private boolean verifyFileIncludesOnlyValidRules(List<UserDomainRuleRecord> domainRuleRecords) {
        List validRules = Arrays.stream(DomainRuleBehaviour.values()).map(Enum::name).filter(name -> !name.equals(DomainRuleBehaviour.BLOCKED.name())).collect(Collectors.toList());
        validRules.add("");
        return domainRuleRecords.stream().map(domainRecord -> domainRecord.getDecision().toUpperCase()).allMatch(validRules::contains);
    }

    private static class CsvDomainRecordResult {
        String errorMessage;
        UserDomainRuleRecord userDomainRule;

        private CsvDomainRecordResult() {
        }
    }
}

