/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericTrackEvent;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class TaskLevelAnalyticsEventBuilder {
    private final PluginVersionManager pluginVersionManager;
    private final Supplier<Instant> instantSupplier;
    private final SENSupplier senSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public TaskLevelAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, SENSupplier senSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this(pluginVersionManager, Instant::now, senSupplier, analyticsEventBuilderUtil);
    }

    @VisibleForTesting
    TaskLevelAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, Supplier<Instant> instantSupplier, SENSupplier senSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.pluginVersionManager = pluginVersionManager;
        this.instantSupplier = instantSupplier;
        this.senSupplier = senSupplier;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    public EventDto buildUpdatedTaskStatusAnalyticEvent(String planId, String taskId, String type, ProgressDto.Status fromStatus, ProgressDto.Status toStatus, String spaceKey) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"oldStatus", (Object)fromStatus.name());
        attributes.put((Object)"newStatus", (Object)toStatus);
        attributes.put((Object)"type", (Object)type);
        attributes.put((Object)"planId", (Object)planId);
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            this.analyticsEventBuilderUtil.feedSpaceIdIfPresent(spaceKey, spaceId -> attributes.put((Object)"spaceId", (Object)Long.toString(spaceId)));
            this.analyticsEventBuilderUtil.feedSpaceStatsIfPresent(spaceKey, spaceStats -> attributes.put((Object)"totalAttachmentsSize", (Object)(spaceStats.getSummary().getAttachments().getTotalSize() != null ? spaceStats.getSummary().getAttachments().getTotalSize() : 0L)));
        }
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("updated")).sen(this.senSupplier.get())).actionSubject("objectStatus", taskId)).withAttributes((Map)attributes.build())).build();
    }
}

