/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.MigrationSpaceStatus;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.service.encryption.AutowireHelper;
import com.atlassian.migration.agent.service.impl.MigrationSpaceStatusService;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;

@Entity
public abstract class AbstractSpaceTask
extends Task {
    @Column(name="spaceKey")
    protected String spaceKey;
    @Transient
    private ExecutionStatus prevExecutionStatus;

    public AbstractSpaceTask() {
        this.prevExecutionStatus = null;
    }

    public AbstractSpaceTask(AbstractSpaceTask spaceTask) {
        super(spaceTask.getWeight(), spaceTask.getIndex());
        this.spaceKey = spaceTask.spaceKey;
        this.prevExecutionStatus = null;
    }

    @PrePersist
    @PreUpdate
    public void onPostPersistOrUpdate() {
        if (this.prevExecutionStatus == null || !this.prevExecutionStatus.equals((Object)this.getProgress().getStatus())) {
            MigrationSpaceStatusService migrationSpaceStatusService = AutowireHelper.getBean(MigrationSpaceStatusService.class);
            MigrationSpaceStatus migrationSpaceStatus = this.getOrCreateMigrationSpaceStatus(this);
            migrationSpaceStatusService.saveOrUpdate(migrationSpaceStatus);
            this.prevExecutionStatus = this.getProgress().getStatus();
        }
    }

    private MigrationSpaceStatus getOrCreateMigrationSpaceStatus(AbstractSpaceTask task) {
        String sk = task.getSpaceKey();
        String cloudId = task.getPlan().getCloudSite().getCloudId();
        String executionStatus = task.getProgress().getStatus().name();
        Instant lastUpdate = Instant.now();
        String planId = task.getPlan().getId();
        return new MigrationSpaceStatus(sk, cloudId, executionStatus, lastUpdate, planId);
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }
}

