/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Arrays;
import lombok.Generated;
import oshi.SystemInfo;

public class CpuStatsCalculator {
    private static final int INITIAL_MEASUREMENT_DURATION = 1000;
    private final double initialLoad = CpuStatsCalculator.measureCpuLoad(1000L);
    private long[][] startTicks = null;
    private long statTime = 0L;

    public static CpuStatsCalculator createCalculator() {
        return new CpuStatsCalculator();
    }

    public void start() {
        this.startTicks = CpuStatsCalculator.getCpuTicks();
        this.statTime = System.currentTimeMillis();
    }

    public CpuStats finish() {
        return new CpuStats(CpuStatsCalculator.getCpuLoad(this.startTicks, this.initialLoad), Duration.ofMillis(System.currentTimeMillis() - this.statTime));
    }

    private static double getCpuLoad(long[][] oldCpuTicks, double cpuLoadBeforeAssessment) {
        double[] cpuLoad = new SystemInfo().getHardware().getProcessor().getProcessorCpuLoadBetweenTicks(oldCpuTicks);
        double queryCpuLoad = Arrays.stream(cpuLoad).summaryStatistics().getAverage();
        return Double.parseDouble(new DecimalFormat("#.00").format(cpuLoadBeforeAssessment - queryCpuLoad));
    }

    private static double measureCpuLoad(long measurementTime) {
        double[] cpuLoad = new SystemInfo().getHardware().getProcessor().getProcessorCpuLoad(measurementTime);
        return Arrays.stream(cpuLoad).summaryStatistics().getAverage();
    }

    private static long[][] getCpuTicks() {
        return new SystemInfo().getHardware().getProcessor().getProcessorCpuLoadTicks();
    }

    static class CpuStats {
        double load;
        Duration duration;

        @Generated
        public double getLoad() {
            return this.load;
        }

        @Generated
        public Duration getDuration() {
            return this.duration;
        }

        @Generated
        public void setLoad(double load) {
            this.load = load;
        }

        @Generated
        public void setDuration(Duration duration) {
            this.duration = duration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CpuStats)) {
                return false;
            }
            CpuStats other = (CpuStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getLoad(), other.getLoad()) != 0) {
                return false;
            }
            Duration this$duration = this.getDuration();
            Duration other$duration = other.getDuration();
            return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CpuStats;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $load = Double.doubleToLongBits(this.getLoad());
            result = result * 59 + (int)($load >>> 32 ^ $load);
            Duration $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CpuStatsCalculator.CpuStats(load=" + this.getLoad() + ", duration=" + this.getDuration() + ")";
        }

        @Generated
        public CpuStats(double load, Duration duration) {
            this.load = load;
            this.duration = duration;
        }
    }
}

