/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.migration.agent.service.guardrails.macro.MacrosAssessmentPerSpace;
import java.util.Set;
import lombok.Generated;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class MacroAssessmentResult {
    @JsonProperty
    private String serverId;
    @JsonProperty
    private String assessmentStartingDate;
    @JsonProperty
    private final long totalNumberOfUniqueContentItems;
    @JsonProperty
    private final long totalNumberOfUniqueMacros;
    @JsonProperty
    private long duration;
    @JsonProperty
    private double cpuLoad;
    @JsonProperty
    private final Set<MacrosAssessmentPerSpace> macrosAssessmentPerSpace;

    public MacroAssessmentResult(Set<MacrosAssessmentPerSpace> macrosAssessmentPerSpace, long totalNumberOfUniqueContentItems, long totalNumberOfUniqueMacros) {
        this.macrosAssessmentPerSpace = macrosAssessmentPerSpace;
        this.totalNumberOfUniqueContentItems = totalNumberOfUniqueContentItems;
        this.totalNumberOfUniqueMacros = totalNumberOfUniqueMacros;
    }

    @JsonCreator
    private MacroAssessmentResult(@JsonProperty(value="macrosAssessmentPerSpace") Set<MacrosAssessmentPerSpace> macrosAssessmentPerSpace, @JsonProperty(value="totalNumberOfUniqueContentItems") long totalNumberOfUniqueContentItems, @JsonProperty(value="totalNumberOfUniqueMacros") long totalNumberOfUniqueMacros, @JsonProperty(value="serverId") String serverId, @JsonProperty(value="assessmentStartingDate") String assessmentStartingDate, @JsonProperty(value="duration") long duration, @JsonProperty(value="cpuLoad") double cpuLoad) {
        this.macrosAssessmentPerSpace = macrosAssessmentPerSpace;
        this.totalNumberOfUniqueContentItems = totalNumberOfUniqueContentItems;
        this.totalNumberOfUniqueMacros = totalNumberOfUniqueMacros;
        this.serverId = serverId;
        this.assessmentStartingDate = assessmentStartingDate;
        this.duration = duration;
        this.cpuLoad = cpuLoad;
    }

    public void addIdentification(String serverId, String assessmentStartingDate) {
        this.serverId = serverId;
        this.assessmentStartingDate = assessmentStartingDate;
    }

    public void addExecutionStats(long duration, double cpuLoad) {
        this.duration = duration;
        this.cpuLoad = cpuLoad;
    }

    @Generated
    public String getServerId() {
        return this.serverId;
    }

    @Generated
    public String getAssessmentStartingDate() {
        return this.assessmentStartingDate;
    }

    @Generated
    public long getTotalNumberOfUniqueContentItems() {
        return this.totalNumberOfUniqueContentItems;
    }

    @Generated
    public long getTotalNumberOfUniqueMacros() {
        return this.totalNumberOfUniqueMacros;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public double getCpuLoad() {
        return this.cpuLoad;
    }

    @Generated
    public Set<MacrosAssessmentPerSpace> getMacrosAssessmentPerSpace() {
        return this.macrosAssessmentPerSpace;
    }

    @Generated
    public String toString() {
        return "MacroAssessmentResult(serverId=" + this.getServerId() + ", assessmentStartingDate=" + this.getAssessmentStartingDate() + ", totalNumberOfUniqueContentItems=" + this.getTotalNumberOfUniqueContentItems() + ", totalNumberOfUniqueMacros=" + this.getTotalNumberOfUniqueMacros() + ", duration=" + this.getDuration() + ", cpuLoad=" + this.getCpuLoad() + ", macrosAssessmentPerSpace=" + this.getMacrosAssessmentPerSpace() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MacroAssessmentResult)) {
            return false;
        }
        MacroAssessmentResult other = (MacroAssessmentResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        String this$assessmentStartingDate = this.getAssessmentStartingDate();
        String other$assessmentStartingDate = other.getAssessmentStartingDate();
        if (this$assessmentStartingDate == null ? other$assessmentStartingDate != null : !this$assessmentStartingDate.equals(other$assessmentStartingDate)) {
            return false;
        }
        if (this.getTotalNumberOfUniqueContentItems() != other.getTotalNumberOfUniqueContentItems()) {
            return false;
        }
        if (this.getTotalNumberOfUniqueMacros() != other.getTotalNumberOfUniqueMacros()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (Double.compare(this.getCpuLoad(), other.getCpuLoad()) != 0) {
            return false;
        }
        Set<MacrosAssessmentPerSpace> this$macrosAssessmentPerSpace = this.getMacrosAssessmentPerSpace();
        Set<MacrosAssessmentPerSpace> other$macrosAssessmentPerSpace = other.getMacrosAssessmentPerSpace();
        return !(this$macrosAssessmentPerSpace == null ? other$macrosAssessmentPerSpace != null : !((Object)this$macrosAssessmentPerSpace).equals(other$macrosAssessmentPerSpace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MacroAssessmentResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        String $assessmentStartingDate = this.getAssessmentStartingDate();
        result = result * 59 + ($assessmentStartingDate == null ? 43 : $assessmentStartingDate.hashCode());
        long $totalNumberOfUniqueContentItems = this.getTotalNumberOfUniqueContentItems();
        result = result * 59 + (int)($totalNumberOfUniqueContentItems >>> 32 ^ $totalNumberOfUniqueContentItems);
        long $totalNumberOfUniqueMacros = this.getTotalNumberOfUniqueMacros();
        result = result * 59 + (int)($totalNumberOfUniqueMacros >>> 32 ^ $totalNumberOfUniqueMacros);
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        long $cpuLoad = Double.doubleToLongBits(this.getCpuLoad());
        result = result * 59 + (int)($cpuLoad >>> 32 ^ $cpuLoad);
        Set<MacrosAssessmentPerSpace> $macrosAssessmentPerSpace = this.getMacrosAssessmentPerSpace();
        result = result * 59 + ($macrosAssessmentPerSpace == null ? 43 : ((Object)$macrosAssessmentPerSpace).hashCode());
        return result;
    }

    @Generated
    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    @Generated
    public void setAssessmentStartingDate(String assessmentStartingDate) {
        this.assessmentStartingDate = assessmentStartingDate;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setCpuLoad(double cpuLoad) {
        this.cpuLoad = cpuLoad;
    }
}

