/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.newexport.processor;

import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.migration.agent.newexport.Query;
import com.atlassian.migration.agent.newexport.processor.CsvSerializingProcessor;
import com.atlassian.migration.agent.newexport.processor.RowProcessor;
import com.atlassian.migration.agent.service.UserMappingsManager;
import com.atlassian.migration.agent.service.util.CsvWriterFacade;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class UserWithEmailSerializingProcessor
implements RowProcessor {
    private static final Logger log = LoggerFactory.getLogger(UserWithEmailSerializingProcessor.class);
    private final UserMappingsManager userMappingsManager;
    private CsvWriterFacade csvWriterFacade;
    public static final String USER_KEY = "user_key";
    public static final String USERNAME = "username";
    public static final String LOWER_USERNAME = "lower_username";
    public static final String EMAIL = "email";
    public static final String AAID = "aaid";
    private final CsvSerializingProcessor delegateProcessor;

    public UserWithEmailSerializingProcessor(RowProcessor processor, UserMappingsManager userMappingsManager) {
        this.userMappingsManager = userMappingsManager;
        this.delegateProcessor = (CsvSerializingProcessor)processor;
        this.csvWriterFacade = this.delegateProcessor.getCsvService();
    }

    @Override
    public void initialise(ResultSet rs, Query query) {
        try {
            this.csvWriterFacade.write(Arrays.asList(USER_KEY, USERNAME, LOWER_USERNAME, EMAIL, AAID).toArray(new String[0]), true);
            this.csvWriterFacade.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(ResultSet rs) {
        try {
            String userKey = rs.getString(USER_KEY);
            String userName = rs.getString(USERNAME);
            String lower = rs.getString(LOWER_USERNAME);
            String email = IdentityAcceptedEmailValidator.cleanse((String)rs.getString(EMAIL));
            if (StringUtils.isEmpty((Object)email)) {
                email = userKey;
            }
            String aaId = this.userMappingsManager.getAaid(userKey, email, null);
            List<String> columValues = Arrays.asList(userKey, userName, lower, email, aaId);
            String[] columnValuesArray = columValues.toArray(new String[0]);
            this.csvWriterFacade.write(columnValuesArray, true);
            this.csvWriterFacade.flush();
            this.delegateProcessor.addRowCount();
            this.delegateProcessor.addContentCharacters(columValues);
        }
        catch (IOException | SQLException e) {
            log.error("Error while serializing data: ", (Throwable)e);
        }
    }
}

