/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mma.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.assessment.AppListResponse;
import com.atlassian.migration.agent.dto.assessment.AppSummaryDto;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.SpaceStatistic;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.mma.model.AppMetadata;
import com.atlassian.migration.agent.mma.model.EntityActionDTO;
import com.atlassian.migration.agent.mma.model.MetadataEntityResult;
import com.atlassian.migration.agent.mma.model.MetadataRefreshState;
import com.atlassian.migration.agent.mma.model.MetadataRefreshStatus;
import com.atlassian.migration.agent.mma.model.MetadataType;
import com.atlassian.migration.agent.mma.model.ProductLicense;
import com.atlassian.migration.agent.mma.model.ServerInstanceDTO;
import com.atlassian.migration.agent.mma.model.SpaceMetadata;
import com.atlassian.migration.agent.mma.model.SpaceMetadataDTO;
import com.atlassian.migration.agent.mma.model.processor.MetadataBatch;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.builders.ServerMetadataAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.agent.service.catalogue.model.ConfluenceLicenseDetails;
import com.atlassian.migration.agent.service.impl.AppAssessmentFacade;
import com.atlassian.migration.agent.service.impl.DefaultSpaceStatistics;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.agent.store.CloudSiteStore;
import com.atlassian.migration.agent.store.impl.SpaceStore;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class MigrationMetadataAggregatorService {
    private final SystemInformationService sysInfoService;
    private final PluginVersionManager pluginVersionManager;
    private final LicenseHandler licenseHandler;
    private final EnterpriseGatekeeperClient enterpriseGatekeeperClient;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final AnalyticsEventService analyticsEventService;
    private final SpaceStore spaceStore;
    private final CloudSiteStore cloudSiteStore;
    private final EventPublisher eventPublisher;
    private final AppAssessmentFacade appAssessmentFacade;
    private final DefaultSpaceStatistics defaultSpaceStatistics;
    private final ExecutorService executorService;
    private final Clock clock;
    private static final Logger log = ContextLoggerFactory.getLogger(MigrationMetadataAggregatorService.class);
    private static final String CONFLUENCE_SERVER_PRODUCT_KEY = "confluence-server";
    static final int BATCH_SIZE_METADATA = 1000;

    public MigrationMetadataAggregatorService(SystemInformationService sysInfoService, PluginVersionManager pluginVersionManager, LicenseHandler licenseHandler, EnterpriseGatekeeperClient enterpriseGatekeeperClient, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SpaceStore spaceStore, CloudSiteStore cloudSiteStore, AnalyticsEventBuilder analyticsEventBuilder, AnalyticsEventService analyticsEventService, EventPublisher eventPublisher, DefaultSpaceStatistics defaultSpaceStatistics, AppAssessmentFacade appAssessmentFacade) {
        this(sysInfoService, pluginVersionManager, licenseHandler, enterpriseGatekeeperClient, migrationDarkFeaturesManager, spaceStore, cloudSiteStore, analyticsEventBuilder, analyticsEventService, eventPublisher, defaultSpaceStatistics, appAssessmentFacade, Clock.systemUTC());
    }

    @VisibleForTesting
    MigrationMetadataAggregatorService(SystemInformationService sysInfoService, PluginVersionManager pluginVersionManager, LicenseHandler licenseHandler, EnterpriseGatekeeperClient enterpriseGatekeeperClient, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SpaceStore spaceStore, CloudSiteStore cloudSiteStore, AnalyticsEventBuilder analyticsEventBuilder, AnalyticsEventService analyticsEventService, EventPublisher eventPublisher, DefaultSpaceStatistics defaultSpaceStatistics, AppAssessmentFacade appAssessmentFacade, Clock clock) {
        this.sysInfoService = sysInfoService;
        this.pluginVersionManager = pluginVersionManager;
        this.licenseHandler = licenseHandler;
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.spaceStore = spaceStore;
        this.cloudSiteStore = cloudSiteStore;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.analyticsEventService = analyticsEventService;
        this.eventPublisher = eventPublisher;
        this.defaultSpaceStatistics = defaultSpaceStatistics;
        this.appAssessmentFacade = appAssessmentFacade;
        this.executorService = Executors.newSingleThreadExecutor();
        this.clock = clock;
    }

    @PostConstruct
    void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    void cleanup() {
        this.eventPublisher.unregister((Object)this);
        this.executorService.shutdown();
    }

    public void sendServerInstanceMetadataToMMAForAllCloudSites() {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.upsertServerInstanceCloudSitePairInMMA(site.getContainerToken(), site.getCloudId()));
    }

    public MetadataRefreshStatus upsertServerInstanceCloudSitePairInMMA(String containerToken, String cloudId) {
        ServerInstanceDTO serverInstance = this.mapServerInstanceDto(cloudId);
        MetadataBatch<ServerInstanceDTO> batchServerInstanceDTO = new MetadataBatch<ServerInstanceDTO>(serverInstance);
        long startTime = System.currentTimeMillis();
        try {
            List<EntityActionDTO> response = this.enterpriseGatekeeperClient.sendServerInstanceInfoToMigrationMetadataAggregator(containerToken, cloudId, batchServerInstanceDTO);
            if (!response.stream().allMatch(EntityActionDTO::isSuccess)) {
                throw new RuntimeException(String.format("Error upserting Server in MMA: [%s]", response.stream().filter(r -> !r.isSuccess()).map(EntityActionDTO::getError).collect(Collectors.toList())));
            }
            log.info("Sent request to MMA for Server Instance\n[{}]", batchServerInstanceDTO);
            EventDto analyticEvent = this.analyticsEventBuilder.buildServerMetadataEvent(cloudId, System.currentTimeMillis() - startTime, Optional.empty());
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
            return MetadataRefreshStatus.SUCCESS;
        }
        catch (Exception e) {
            log.error("Failed to send server instance metadata to MMA for cloud [{}].", (Object)cloudId, (Object)e);
            EventDto analyticEvent = this.analyticsEventBuilder.buildServerMetadataEvent(cloudId, System.currentTimeMillis() - startTime, Optional.of(e));
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
            return MetadataRefreshStatus.FAILURE;
        }
    }

    private ServerInstanceDTO mapServerInstanceDto(String cloudId) {
        return ServerInstanceDTO.builder().cloudId(cloudId).serverId(this.sysInfoService.getConfluenceInfo().getServerId()).supportEntitlementNumber(this.sysInfoService.getConfluenceInfo().getSupportEntitlementNumber()).productVersion(this.sysInfoService.getConfluenceInfo().getVersion()).serverBaseUrl(this.sysInfoService.getConfluenceInfo().getBaseUrl()).cmaVersion(this.pluginVersionManager.getPluginVersion()).organizationName(this.getOrganisationName()).productKey(CONFLUENCE_SERVER_PRODUCT_KEY).userCount(this.sysInfoService.getUsageInfo().getLocalUsers()).licenseDetails(this.buildLicenseDetails()).build();
    }

    private List<ProductLicense> buildLicenseDetails() {
        return Optional.ofNullable(this.licenseHandler.getProductLicenseDetails("conf")).map(ConfluenceLicenseDetails::from).map(ProductLicense::from).map(Collections::singletonList).orElse(null);
    }

    private String getOrganisationName() {
        return this.licenseHandler.getAllProductLicenses().stream().map(BaseLicenseDetails::getOrganisationName).findFirst().orElse(null);
    }

    public void sendSpaceMetadataToMMAForAllCloudSites() {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.sendSpaceMetadataToMMA(site.getContainerToken(), site.getCloudId(), serverId));
    }

    public void sendAppMetadataToMMAForAllCloudSites() {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.sendAppMetadataToMMA(site.getContainerToken(), site.getCloudId(), serverId));
    }

    public void deleteSpaceMetadata(String containerToken, String cloudId, String serverId) {
        long startTime = System.currentTimeMillis();
        Exception ex = null;
        try {
            this.enterpriseGatekeeperClient.deleteSpaceMetadataFromMigrationMetadataAggregator(containerToken, cloudId, serverId);
            log.info("Deleted Spaces in MMA for Cloud/Server ID pair [{},{}].", (Object)cloudId, (Object)serverId);
        }
        catch (Exception e) {
            ex = e;
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.DELETED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, System.currentTimeMillis() - startTime, ex, null);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    public MetadataRefreshStatus sendSpaceMetadataToMMA(String containerToken, String cloudId, String serverId) {
        this.deleteSpaceMetadata(containerToken, cloudId, serverId);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        List spaceMetadata = Collections.emptyList();
        long startTime = System.currentTimeMillis();
        try {
            spaceMetadata = this.spaceStore.getSpaceMetadata().stream().map(s -> new SpaceMetadataDTO((SpaceMetadata)s, cloudId, serverId)).collect(Collectors.toList());
            List responses = Lists.partition(spaceMetadata, (int)1000).stream().map(spaceMetadataChunk -> {
                try {
                    return this.enterpriseGatekeeperClient.sendSpaceMetadataToMigrationMetadataAggregator(containerToken, cloudId, new MetadataBatch<SpaceMetadataDTO>((List<SpaceMetadataDTO>)spaceMetadataChunk));
                }
                catch (Exception e) {
                    log.error("There was an error sending a batch of metadata to MMA: {}", (Object)e.getMessage());
                    exceptions.add(e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            log.info("Emitted latest Space metadata to MMA. Sent [{}] spaces in [{}] successful batches", (Object)spaceMetadata.size(), (Object)responses.size());
            MetadataRefreshStatus metadataRefreshStatus = exceptions.isEmpty() ? MetadataRefreshStatus.SUCCESS : MetadataRefreshStatus.FAILURE;
            return metadataRefreshStatus;
        }
        catch (Exception e) {
            exceptions.add(e);
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.UPDATED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, System.currentTimeMillis() - startTime, 1000, spaceMetadata.size(), exceptions);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    public void deleteAppMetadata(String containerToken, String cloudId, String serverId) {
        long startTime = System.currentTimeMillis();
        Exception ex = null;
        try {
            this.enterpriseGatekeeperClient.deleteAppMetadataFromMigrationMetadataAggregator(containerToken, cloudId, serverId);
            log.info("Deleted Apps in MMA for Cloud/Server ID pair [{},{}].", (Object)cloudId, (Object)serverId);
        }
        catch (Exception e) {
            ex = e;
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.DELETED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, System.currentTimeMillis() - startTime, ex, null);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    public MetadataRefreshStatus sendAppMetadataToMMA(String containerToken, String cloudId, String serverId) {
        this.deleteAppMetadata(containerToken, cloudId, serverId);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        List appMetadata = Collections.emptyList();
        long startTime = System.currentTimeMillis();
        try {
            AppListResponse<AppSummaryDto> apps = this.appAssessmentFacade.getPlugins();
            appMetadata = apps.getApps().stream().map(app -> new AppMetadata((AppSummaryDto)app, cloudId, serverId)).collect(Collectors.toList());
            List responses = Lists.partition(appMetadata, (int)1000).stream().map(appMetadataChunk -> {
                try {
                    return this.enterpriseGatekeeperClient.sendAppMetadataToMigrationMetadataAggregator(containerToken, cloudId, new MetadataBatch<AppMetadata>((List<AppMetadata>)appMetadataChunk));
                }
                catch (Exception e) {
                    log.error("There was an error sending a batch of metadata to MMA: {}", (Object)e.getMessage());
                    exceptions.add(e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            log.info("Emitted latest Space metadata to MMA. Sent [{}] app in [{}] successful batches", (Object)appMetadata.size(), (Object)responses.size());
            MetadataRefreshStatus metadataRefreshStatus = exceptions.isEmpty() ? MetadataRefreshStatus.SUCCESS : MetadataRefreshStatus.FAILURE;
            return metadataRefreshStatus;
        }
        catch (Exception e) {
            exceptions.add(e);
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.UPDATED, ServerMetadataAnalyticsEventBuilder.ActionSubject.APPS, System.currentTimeMillis() - startTime, 1000, appMetadata.size(), exceptions);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    public void replaceAllMetadata(String cloudId) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            log.warn("Discarding request to update all metadata in cloud because cloud first migrations is not enabled.");
        } else {
            Optional<Exception> maybeFailure = Optional.empty();
            long startTime = this.clock.millis();
            try {
                String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
                Optional<CloudSite> cloudSite = this.cloudSiteStore.getByCloudId(cloudId);
                if (!cloudSite.isPresent()) {
                    throw new IllegalArgumentException(String.format("The given cloud site (%s) does not exist or hasn't been connected to this server.", cloudId));
                }
                HashMap<MetadataType, MetadataEntityResult> results = new HashMap<MetadataType, MetadataEntityResult>();
                MetadataRefreshStatus serverResult = this.upsertServerInstanceCloudSitePairInMMA(cloudSite.get().getContainerToken(), cloudId);
                MetadataRefreshStatus spaceResult = this.sendSpaceMetadataToMMA(cloudSite.get().getContainerToken(), cloudId, serverId);
                MetadataRefreshStatus appResult = this.sendAppMetadataToMMA(cloudSite.get().getContainerToken(), cloudId, serverId);
                results.put(MetadataType.SERVER_INSTANCE, new MetadataEntityResult(serverResult));
                results.put(MetadataType.SPACES, new MetadataEntityResult(spaceResult));
                results.put(MetadataType.APPS, new MetadataEntityResult(appResult));
                this.sendStatusUpdate(cloudSite.get().getContainerToken(), cloudId, serverId, results);
            }
            catch (Exception e) {
                maybeFailure = Optional.of(e);
                throw e;
            }
            finally {
                long timeTaken = this.clock.millis() - startTime;
                EventDto eventDto = this.analyticsEventBuilder.buildMetadataReplaceEvent(cloudId, timeTaken, maybeFailure);
                this.analyticsEventService.saveAnalyticsEvent(eventDto);
            }
        }
    }

    public void sendStatusUpdate(String containerToken, String cloudId, String serverId, @NotNull Map<MetadataType, MetadataEntityResult> metadataStatus) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        MetadataRefreshState refreshState = new MetadataRefreshState(metadataStatus);
        this.enterpriseGatekeeperClient.sendRefreshStatusUpdtateToMigrationMetadataAggregatorForSingleEntity(containerToken, cloudId, serverId, refreshState);
    }

    @EventListener
    public void spaceCreatedEventHandler(SpaceCreateEvent event) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                this.handleSpaceCreatedEvent(event);
            }
            catch (Exception e) {
                log.error("There was an error in creating the metadata for spaceId {} in MMA: {}", (Object)event.getSpace().getId(), (Object)e.getMessage());
            }
        });
    }

    public void handleSpaceCreatedEvent(SpaceCreateEvent event) {
        SpaceStatistic defaultMetadata = this.defaultSpaceStatistics.createDefaultStats(event.getSpace().getId(), event.getSpace().getLastModificationDate());
        SpaceMetadata changedSpaceMetadata = new SpaceMetadata(event.getSpace().getId(), event.getSpace().getKey(), event.getSpace().getName(), event.getSpace().getType(), defaultMetadata.getSumOfPageBlogDraftCount(), defaultMetadata.getAttachmentSize(), defaultMetadata.getAttachmentCount(), defaultMetadata.getEstimatedMigrationTime(), new Timestamp(event.getSpace().getLastModificationDate().getTime()), defaultMetadata.getTeamCalendarCount());
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.sendSpaceMetadataToMMAForSingleEntity(changedSpaceMetadata, site.getContainerToken(), site.getCloudId()));
    }

    public void sendSpaceMetadataToMMAForSingleEntity(SpaceMetadata changedSpaceMetadata, String containerToken, String cloudId) {
        long startTime = System.currentTimeMillis();
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        SpaceMetadataDTO metadataToSend = new SpaceMetadataDTO(changedSpaceMetadata, cloudId, serverId);
        Exception exception = null;
        try {
            this.enterpriseGatekeeperClient.sendSpaceMetadataToMigrationMetadataAggregatorForSingleEntity(containerToken, cloudId, serverId, metadataToSend);
        }
        catch (Exception e) {
            log.error("There was an error sending metadata for spaceId {} to MMA: {}", (Object)metadataToSend.getSpaceId(), (Object)e.getMessage());
            exception = e;
        }
        EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.UPDATED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, startTime - System.currentTimeMillis(), exception, 1);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
    }

    @EventListener
    public void spaceRemoveEventHandler(SpaceRemoveEvent event) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                this.handleSpaceRemoveEvent(event);
            }
            catch (Exception e) {
                log.error("There was an error in removing the metadata for spaceId {} in MMA: {}", (Object)event.getSpace().getId(), (Object)e.getMessage());
            }
        });
    }

    public void handleSpaceRemoveEvent(SpaceRemoveEvent event) {
        long spaceId = event.getSpace().getId();
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        nonFailingCloudSites.forEach(site -> this.deleteSpaceMetadataFromMMAForSingleEntity(site.getContainerToken(), site.getCloudId(), serverId, spaceId));
    }

    public void deleteSpaceMetadataFromMMAForSingleEntity(String containerToken, String cloudId, String serverId, long spaceId) {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        try {
            this.enterpriseGatekeeperClient.deleteSpaceMetadataFromMigrationMetadataAggregator(containerToken, cloudId, serverId, spaceId);
        }
        catch (Exception e) {
            log.error("There was an error deleting metadata in MMA for a spaceId {}: {}", (Object)spaceId, (Object)e.getMessage());
            exception = e;
        }
        EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.DELETED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, startTime - System.currentTimeMillis(), exception, 1);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
    }

    @EventListener
    public void spaceUpdateEventHandler(SpaceUpdateEvent event) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                this.handleSpaceUpdateEvent(event);
            }
            catch (Exception e) {
                log.error("There was an error in updating the metadata for spaceId {} in MMA: {}", (Object)event.getSpace().getId(), (Object)e.getMessage());
            }
        });
    }

    public void handleSpaceUpdateEvent(SpaceUpdateEvent event) {
        if (!event.getOriginalSpace().getName().equals(event.getSpace().getName())) {
            SpaceMetadata oldSpaceMetadata = this.spaceStore.getSpaceMetadataForIndividualSpace(event.getOriginalSpace().getId());
            SpaceMetadata changedSpaceMetadata = new SpaceMetadata(event.getSpace().getId(), event.getSpace().getKey(), event.getSpace().getName(), event.getSpace().getType(), oldSpaceMetadata.getSumOfPageBlogDraftCount(), oldSpaceMetadata.getAttachmentSize(), oldSpaceMetadata.getAttachmentCount(), oldSpaceMetadata.getEstimatedMigrationTime(), new Timestamp(event.getSpace().getLastModificationDate().getTime()), oldSpaceMetadata.getTeamCalendarCount());
            List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
            nonFailingCloudSites.forEach(site -> this.sendSpaceMetadataToMMAForSingleEntity(changedSpaceMetadata, site.getContainerToken(), site.getCloudId()));
        }
    }
}

