/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.CounterMetricEvent;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.agent.dto.MigrationDetailsDto;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.MigrationTag;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.MigrationMetric;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventConstants;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.event.StepAllocation;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class StepLevelAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final PluginVersionManager pluginVersionManager;
    private final SpaceManager spaceManager;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public StepLevelAnalyticsEventBuilder(SENSupplier senSupplier, PluginVersionManager pluginVersionManager, SpaceManager spaceManager, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this(senSupplier, Instant::now, pluginVersionManager, spaceManager, analyticsEventBuilderUtil);
    }

    StepLevelAnalyticsEventBuilder(SENSupplier senSupplier, Supplier<Instant> instantSupplier, PluginVersionManager pluginVersionManager, SpaceManager spaceManager, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.pluginVersionManager = pluginVersionManager;
        this.spaceManager = spaceManager;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    public EventDto buildSpaceStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String spaceKey, Step step) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, action, spaceKey, step, null, Collections.emptyMap());
    }

    public EventDto buildSpaceStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String spaceKey, Step step, Map<String, Object> additionalAttributes) {
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, action, spaceKey, step, null, additionalAttributes);
    }

    public EventDto buildSpaceStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String spaceKey, String planId, String taskId, Boolean isGDPRReady, Map<String, Object> additionalAttributes) {
        ImmutableMap.Builder<String, Object> attributes = this.getSpaceStepTimeEventCommonAttributes(stepSuccessful, totalTime, spaceKey, isGDPRReady, additionalAttributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).actionSubject("space", taskId)).withAttributes((Map)attributes.build())).contextContainer("plan", planId)).build();
    }

    public EventDto buildSpaceStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String spaceKey, Step step, Boolean isGDPRReady, Map<String, Object> additionalAttributes) {
        String planId = step.getPlan().getId();
        String taskId = step.getTask().getId();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("stepId", step.getId());
        attributes.putAll(additionalAttributes);
        return this.buildSpaceStepTimerEvent(stepSuccessful, totalTime, action, spaceKey, planId, taskId, isGDPRReady, attributes);
    }

    private ImmutableMap.Builder<String, Object> getSpaceStepTimeEventCommonAttributes(boolean stepSuccessful, long totalTime, String spaceKey, Boolean isGDPRReady, Map<String, Object> additionalAttributes) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        this.analyticsEventBuilderUtil.feedSpaceIdIfPresent(spaceKey, spaceId -> attributes.put((Object)"spaceId", (Object)Long.toString(spaceId)));
        attributes.put((Object)"stepSuccessful", (Object)stepSuccessful);
        this.analyticsEventBuilderUtil.feedSpaceStatsIfPresent(spaceKey, spaceStats -> {
            ContentSummary contentSummary = spaceStats.getSummary();
            attributes.put((Object)"numberOfAttachments", (Object)Long.toString(contentSummary.getNumberOfAttachments() != null ? contentSummary.getNumberOfAttachments() : 0L));
            attributes.put((Object)"numberOfBlogs", (Object)Long.toString(contentSummary.getNumberOfBlogs() != null ? contentSummary.getNumberOfBlogs() : 0L));
            attributes.put((Object)"numberOfDrafts", (Object)Long.toString(contentSummary.getNumberOfDrafts() != null ? contentSummary.getNumberOfDrafts() : 0L));
            attributes.put((Object)"numberOfPages", (Object)Long.toString(contentSummary.getNumberOfPages() != null ? contentSummary.getNumberOfPages() : 0L));
            attributes.put((Object)"numberOfTeamCalendars", (Object)Long.toString(contentSummary.getNumberOfTeamCalendars() != null ? contentSummary.getNumberOfTeamCalendars() : 0L));
            Long totalSize = contentSummary.getAttachments().getTotalSize();
            if (totalSize != null) {
                attributes.put((Object)"totalAttachmentsSize", (Object)Long.toString(totalSize));
            } else {
                attributes.put((Object)"totalAttachmentsSize", (Object)Long.toString(0L));
            }
        });
        attributes.put((Object)"timeTaken", (Object)Long.toString(totalTime));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.putAll(additionalAttributes);
        if (isGDPRReady != null) {
            attributes.put((Object)"isGDPRReady", (Object)Boolean.toString(isGDPRReady));
        }
        return attributes;
    }

    public EventDto buildPlatformStepCompletionExtendedMetricEvent(String stepKey, ExecutionStatus status, MigrationTag migrationTag) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        Map<String, String> tagsMap = this.analyticsEventBuilderUtil.buildPlatformCounterMetricCommonTags(status, migrationTag);
        attributes.put((Object)"platformEvent", (Object)true);
        tagsMap.put("version", this.pluginVersionManager.getPluginVersion());
        Map<String, String> eventAttributesMap = AnalyticsEventConstants.stepCompletionEventAttributesMap.get(stepKey);
        String component = this.analyticsEventBuilderUtil.getValueFromEventAttributesMap(eventAttributesMap, "component");
        tagsMap.put("phase", this.analyticsEventBuilderUtil.getValueFromEventAttributesMap(eventAttributesMap, "phase"));
        String metricName = MigrationMetric.MIGRATIONS_COMPONENT_LEVEL_SUCCESS_RATE.metricName + "." + component.toLowerCase();
        return ((CounterMetricEvent.Builder)((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(metricName).withAttributes((Map)attributes.build())).tags(tagsMap)).build();
    }

    public EventDto buildFailedSpaceMigration(StepType stepType, MigrationErrorCode migrationErrorCode) {
        Map<String, String> tagsMap = this.analyticsEventBuilderUtil.buildCounterMetricCommonTags();
        tagsMap.put("step", stepType.name());
        if (migrationErrorCode.shouldBeTreatedAsGoodEventInReliabilitySlo()) {
            tagsMap.put("result", "success");
            return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.SPACE_MIGRATION_COUNT.metricName).tags(tagsMap)).build();
        }
        tagsMap.put("result", "fail");
        tagsMap.put("error_code", String.valueOf(migrationErrorCode.getCode()));
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.SPACE_MIGRATION_COUNT.metricName).tags(tagsMap)).build();
    }

    public EventDto buildSuccessfulSpaceMigration() {
        Map<String, String> tagsMap = this.analyticsEventBuilderUtil.buildCounterMetricCommonTags();
        tagsMap.put("result", "success");
        return ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.SPACE_MIGRATION_COUNT.metricName).tags(tagsMap)).build();
    }

    public EventDto buildCompletedStepAnalyticsEvent(Step step) {
        return this.buildCompletedStepAnalyticsEvent(step, Collections::emptyMap);
    }

    public EventDto buildCompletedStepAnalyticsEvent(Step step, Supplier<Map<String, String>> additionalAttributes) {
        long startTime = this.instantSupplier.get().toEpochMilli();
        Optional<Instant> optionalStartTime = step.getProgress().getStartTime();
        if (optionalStartTime.isPresent()) {
            startTime = optionalStartTime.get().toEpochMilli();
        }
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderStepAnalyticsEvent(step, startTime);
        attributes.put((Object)"status", (Object)step.getProgress().getStatus());
        attributes.put((Object)"stopTime", (Object)this.instantSupplier.get().toEpochMilli());
        additionalAttributes.get().entrySet().stream().forEach(entry -> attributes.put(entry.getKey(), entry.getValue()));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("completed")).sen(this.senSupplier.get())).actionSubject("step", step.getId())).contextContainer("plan", step.getPlan().getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildStepSkipAnalyticEvent(Step step, String reason) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"stepType", (Object)step.getType());
        attributes.put((Object)"stepId", (Object)step.getId());
        attributes.put((Object)"reason", (Object)reason);
        attributes.put((Object)"migrationId", (Object)step.getPlan().getMigrationId());
        attributes.put((Object)"taskId", (Object)step.getTask().getId());
        attributes.put((Object)"taskType", (Object)step.getTask().getAnalyticsEventType());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("logged")).sen(this.senSupplier.get())).actionSubject("skippedStep")).cloudId(step.getPlan().getCloudSite().getCloudId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildStuckStepAnalyticsEvent(Step step, Optional<StepAllocation> oldStepAllocation) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"stepType", (Object)step.getType());
        attributes.put((Object)"migrationId", (Object)step.getPlan().getMigrationId());
        attributes.put((Object)"taskId", (Object)step.getTask().getId());
        attributes.put((Object)"status", (Object)step.getProgress().getStatus());
        attributes.put((Object)"nodeId", (Object)step.getNodeId());
        attributes.put((Object)"nodeExecutionId", (Object)step.getNodeExecutionId());
        attributes.put((Object)"executionState", (Object)step.getExecutionState());
        attributes.put((Object)"nodeHeartBeat", (Object)step.getNodeHeartbeat().toString());
        if (oldStepAllocation.isPresent()) {
            StepAllocation stepAllocation = oldStepAllocation.get();
            attributes.put((Object)"oldStepAllocationNodeId", (Object)stepAllocation.getNodeId());
            attributes.put((Object)"oldStepAllocationNodeExecutionId", (Object)stepAllocation.getNodeExecutionId());
        }
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("stuck")).sen(this.senSupplier.get())).actionSubject("step", step.getId())).contextContainer("plan", step.getPlan().getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildStepLevelHeapSizeAnalyticsEvent(Step step, long freeHeapSizeAtStart, int clusterConcurrency, int nodeConcurrency) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        long freeHeapSize = Runtime.getRuntime().freeMemory();
        attributes.put((Object)"stepType", (Object)step.getType());
        attributes.put((Object)"migrationId", (Object)step.getPlan().getMigrationId());
        attributes.put((Object)"taskId", (Object)step.getTask().getId());
        attributes.put((Object)"configuredHeapSize", (Object)Long.toString(configuredHeapSize));
        attributes.put((Object)"freeHeapSizeAtStart", (Object)Long.toString(freeHeapSizeAtStart));
        attributes.put((Object)"usedHeapSize", (Object)Long.toString(freeHeapSizeAtStart - freeHeapSize));
        attributes.put((Object)"executorConcurrencyCluster", (Object)Integer.toString(clusterConcurrency));
        attributes.put((Object)"executorConcurrencyNode", (Object)Integer.toString(nodeConcurrency));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("fetched")).sen(this.senSupplier.get())).actionSubject("stepHeapSizeAnalytics", step.getId())).contextContainer("plan", step.getPlan().getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPlatformStepCompletionOperationalEvent(Step step, ExecutionStatus status) {
        String spaceKey;
        Space space;
        Plan plan = step.getPlan();
        boolean confluenceSpaceTask = step.getTask() instanceof ConfluenceSpaceTask;
        String stepType = step.getType();
        Optional<String> containerId = Optional.empty();
        String migrationId = plan.getMigrationId();
        if (confluenceSpaceTask && (space = this.spaceManager.getSpace(spaceKey = ((ConfluenceSpaceTask)step.getTask()).getSpaceKey())) != null) {
            containerId = Optional.of(String.valueOf(space.getId()));
        }
        String stepId = step.getId();
        String migrationScopeId = plan.getMigrationScopeId();
        String planId = plan.getId();
        String cloudId = plan.getCloudSite().getCloudId();
        MigrationTag migrationTag = plan.getMigrationTag();
        return this.buildPlatformStepCompletionOperationalEventUtil(new MigrationDetailsDto(migrationId, migrationScopeId, planId, cloudId, stepId), containerId, stepType, status, migrationTag);
    }

    public EventDto buildPlatformStepCompletionOperationalEventUtil(MigrationDetailsDto migrationDetailsDto, Optional<String> containerId, String stepType, ExecutionStatus status, MigrationTag migrationTag) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getSourceDestinationLocation(migrationDetailsDto.cloudId);
        attributes.put((Object)"productFamily", (Object)"CONFLUENCE");
        attributes.put((Object)"migrationType", (Object)"S2C_MIGRATION");
        attributes.put((Object)"platformEvent", (Object)true);
        attributes.put((Object)"migrationId", (Object)migrationDetailsDto.getMigrationId());
        if (containerId.isPresent()) {
            attributes.put((Object)"containerId", (Object)containerId.get());
        }
        attributes.put((Object)"stepType", (Object)stepType);
        attributes.put((Object)"migrationTag", (Object)migrationTag.name());
        attributes.put((Object)"transferId", (Object)migrationDetailsDto.getStepId());
        attributes.put((Object)"migrationScopeId", (Object)migrationDetailsDto.getMigrationScopeId());
        attributes.put((Object)"planId", (Object)migrationDetailsDto.getPlanId());
        attributes.put((Object)"version", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"status", (Object)this.analyticsEventBuilderUtil.convertToProgressStatus(status).getStatusName());
        Map<String, String> eventAttributesMap = AnalyticsEventConstants.stepCompletionEventAttributesMap.get(stepType);
        for (String key : AnalyticsEventConstants.KEYS) {
            attributes.put((Object)key, (Object)this.analyticsEventBuilderUtil.getValueFromEventAttributesMap(eventAttributesMap, key));
        }
        this.analyticsEventBuilderUtil.addConfluenceAndDBVersionInAttributes(attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("completed")).actionSubject("transfer", migrationDetailsDto.getStepId())).contextContainer("migration", migrationDetailsDto.getMigrationId())).cloudId(migrationDetailsDto.getCloudId())).withAttributes((Map)attributes.build())).build();
    }
}

