/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.dto;

import com.atlassian.migration.agent.dto.util.UserMigrationType;
import com.atlassian.migration.agent.entity.GlobalEntityType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jetbrains.annotations.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UsersGroupsStatsRequestDto {
    @JsonProperty
    @Nonnull
    private final UserMigrationType userMigrationType;
    @JsonProperty
    @Nonnull
    private final List<String> spaceKeys;
    @JsonProperty
    @Nonnull
    private final Optional<GlobalEntityType> globalEntityType;

    @JsonCreator
    public UsersGroupsStatsRequestDto(@JsonProperty(value="userMigrationType") String userMigrationType, @JsonProperty(value="spaceKeys") List<String> spaceKeys, @JsonProperty(value="globalEntityType") String globalEntityType) {
        this.userMigrationType = userMigrationType == null ? UserMigrationType.NONE : UserMigrationType.valueOf(userMigrationType.toUpperCase());
        this.spaceKeys = spaceKeys == null ? Collections.emptyList() : spaceKeys.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        this.globalEntityType = globalEntityType == null || globalEntityType.equals("NONE") ? Optional.empty() : Optional.of(GlobalEntityType.valueOf(globalEntityType.toUpperCase()));
    }

    @NotNull
    public List<String> getSpaceKeys() {
        return this.spaceKeys;
    }

    @NotNull
    public UserMigrationType getUserMigrationType() {
        return this.userMigrationType;
    }

    @NotNull
    public Optional<GlobalEntityType> getGlobalEntityType() {
        return this.globalEntityType;
    }
}

