/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.prc;

import com.atlassian.migration.agent.mapi.executor.CloudExecutorService;
import com.atlassian.migration.agent.mapi.external.model.PublicApiException;
import com.atlassian.migration.agent.mma.service.MigrationMetadataAggregatorService;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.prc.model.CheckCommandPayload;
import com.atlassian.migration.agent.service.prc.model.CheckTypes;
import com.atlassian.migration.agent.service.prc.model.CommandName;
import com.atlassian.migration.agent.service.prc.model.CommandOptions;
import com.atlassian.migration.agent.service.prc.model.CommandPayload;
import com.atlassian.migration.agent.service.prc.model.MigrateCommandPayload;
import com.atlassian.migration.agent.service.prc.model.ReplaceAllMetadataCommandPayload;
import com.atlassian.migration.prc.model.Command;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrcCommandExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrcCommandExecutor.class);
    private final CloudExecutorService cloudExecutorService;
    private final MigrationMetadataAggregatorService migrationMetadataAggregatorService;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Map<String, Consumer<Command>> commandExecutorMap = ImmutableMap.of((Object)CommandName.CHECK.getName(), this::executeCheckCommand, (Object)CommandName.MIGRATE.getName(), this::executeMigrateCommand, (Object)CommandName.REPLACE_ALL_METADATA.getName(), this::executeReplaceAllMetadataCommand);

    public PrcCommandExecutor(CloudExecutorService cloudExecutorService, MigrationMetadataAggregatorService migrationMetadataAggregatorService) {
        this.cloudExecutorService = cloudExecutorService;
        this.migrationMetadataAggregatorService = migrationMetadataAggregatorService;
    }

    public void executeCommand(Command command) {
        try {
            this.commandExecutorMap.get(command.getName().toLowerCase()).accept(command);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Unknown command: " + command.getName());
        }
        catch (PublicApiException.InvalidCheckType e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Exception e) {
            log.error("Failed to execute command: " + command.getName(), (Throwable)e);
        }
    }

    private void executeCheckCommand(Command command) {
        CheckCommandPayload commandPayload = this.getCommandPayload(command, CheckCommandPayload.class);
        String jobId = commandPayload.getJobId();
        String taskId = commandPayload.getTaskId();
        String cloudId = commandPayload.getDestId();
        Set<CheckType> checkTypes = this.getCheckTypes(commandPayload.getOptions());
        this.cloudExecutorService.executePreflightChecks(jobId, taskId, cloudId, checkTypes);
    }

    private void executeMigrateCommand(Command command) {
        MigrateCommandPayload commandPayload = this.getCommandPayload(command, MigrateCommandPayload.class);
        String jobId = commandPayload.getJobId();
        String taskId = commandPayload.getTaskId();
        String cloudId = commandPayload.getDestId();
        this.cloudExecutorService.executeMigration(jobId, taskId, cloudId);
    }

    private void executeReplaceAllMetadataCommand(Command command) {
        ReplaceAllMetadataCommandPayload commandPayload = this.getCommandPayload(command, ReplaceAllMetadataCommandPayload.class);
        String cloudId = commandPayload.getDestId();
        this.migrationMetadataAggregatorService.replaceAllMetadata(cloudId);
    }

    private <T extends CommandPayload> T getCommandPayload(Command command, Class<T> classType) {
        try {
            return (T)((CommandPayload)OBJECT_MAPPER.readValue(command.getPayload(), classType));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<CheckType> getCheckTypes(CommandOptions options) {
        Set<CheckType> allChecks = CheckType.getStaticCheckTypes();
        if (options == null) {
            return allChecks;
        }
        CheckTypes checkTypes = options.getCheckTypes();
        if (checkTypes == null) {
            return allChecks;
        }
        Set<CheckType> includeKeys = this.getCheckTypeSetFromKeyList(checkTypes.getIncludeKeys());
        Set<CheckType> excludeKeys = this.getCheckTypeSetFromKeyList(checkTypes.getExcludeKeys());
        return !includeKeys.isEmpty() ? includeKeys : allChecks.stream().filter(checkType -> !excludeKeys.contains(checkType)).collect(Collectors.toSet());
    }

    private Set<CheckType> getCheckTypeSetFromKeyList(List<String> keys) {
        if (keys == null) {
            return Collections.emptySet();
        }
        HashSet<CheckType> validCheckTypes = new HashSet<CheckType>();
        HashSet invalidCheckTypes = new HashSet();
        keys.forEach(key -> {
            if (CheckType.fromString(key).equals(CheckType.UNKNOWN_CHECK_TYPE)) {
                invalidCheckTypes.add(CheckType.fromString(key));
            } else {
                validCheckTypes.add(CheckType.fromString(key));
            }
        });
        if (!invalidCheckTypes.isEmpty()) {
            throw new PublicApiException.InvalidCheckType(((Object)invalidCheckTypes).toString());
        }
        return validCheckTypes;
    }
}

