/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.dto.AppsProgressDto;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.catalogue.MigrationDetails;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.app.DefaultRegistrar;
import com.atlassian.migration.app.dto.AppContainerDetails;
import com.atlassian.migration.app.dto.AppProgress;
import com.atlassian.migration.app.dto.AppProgressResponse;
import com.atlassian.migration.app.dto.MigrationProgress;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class AppMigrationDevelopmentService {
    private final PluginTransactionTemplate ptx;
    private final DefaultRegistrar registrar;
    private final PlanStore planStore;
    private final PlatformService platformService;
    private static final Logger log = ContextLoggerFactory.getLogger(AppMigrationDevelopmentService.class);

    public AppMigrationDevelopmentService(PluginTransactionTemplate ptx, DefaultRegistrar registrar, PlanStore planStore, PlatformService platformService) {
        this.ptx = ptx;
        this.registrar = registrar;
        this.planStore = planStore;
        this.platformService = platformService;
    }

    public void rerunAppMigrationForPlan(String planId) {
        this.rerunAppMigrationForPlan(planId, null);
    }

    public void rerunAppMigrationForPlan(String planId, Set<String> appKeys) {
        log.info("Re-running App migration for planId: {}", (Object)planId);
        this.ptx.read(() -> {
            Plan plan = this.planStore.getPlan(planId);
            MigrationDetails migrationDetails = this.platformService.publishMigrationDetailsForAllListeners(plan);
            String cloudId = plan.getCloudSite().getCloudId();
            String migrationId = migrationDetails.migrationId;
            this.platformService.createContainersInMcs(cloudId, migrationId, plan);
            this.platformService.createAppContainers(cloudId, migrationId, appKeys);
            Set<AppContainerDetails> appContainerDetails = this.platformService.getAppContainers(cloudId, migrationId);
            this.registrar.startMigration(cloudId, migrationId, appContainerDetails);
        });
    }

    public AppProgressResponse getAppMigrationProgress(String planId) {
        return this.ptx.read(() -> {
            Plan plan = this.planStore.getPlan(planId);
            List<AppsProgressDto.App> appProgress = this.registrar.getAppMigrationServiceClient().getAppProgress(plan.getCloudSite().getCloudId(), plan.getMigrationId());
            return new AppProgressResponse((Collection)Lists.newArrayList((Object[])new MigrationProgress[]{new MigrationProgress(plan.getMigrationId(), appProgress.stream().map(app -> new AppProgress(app.getServerAppKey(), app.getContainerId(), app.getCloudAppKey(), app.getCompletionPercent().intValue(), app.getStatus(), app.getStatusMessage(), app.getLastUpdatedAt().longValue())).collect(Collectors.toList()))}));
        });
    }
}

