/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.util;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.guardrails.GuardrailsCsvEncoder;
import com.atlassian.migration.agent.service.util.PreferenceType;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvWriterFacade {
    private CsvListWriter superCsvWriter;
    private CSVWriter openCsvWriter;
    private MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public CsvWriterFacade(MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public void initialise(Writer writer, PreferenceType preferenceType) {
        if (this.isCsvReplacementEnabled()) {
            this.openCsvWriter = preferenceType == PreferenceType.DEFAULT ? new CSVWriter(writer, ',', '\"', '\"', "\n") : (preferenceType == PreferenceType.STANDARD ? new CSVWriter(writer, ',', '\"', '\"', "\r\n") : new CSVWriter(writer, ',', '\"', '\u0000', "\r\n"));
        } else {
            this.superCsvWriter = preferenceType == PreferenceType.DEFAULT ? new CsvListWriter(writer, new CsvPreference.Builder(CsvPreference.EXCEL_PREFERENCE).useQuoteMode((csvColumn, csvContext, csvPreference) -> Objects.nonNull(csvColumn)).build()) : (preferenceType == PreferenceType.STANDARD ? new CsvListWriter(writer, CsvPreference.STANDARD_PREFERENCE) : new CsvListWriter(writer, new CsvPreference.Builder('\"', 44, "\r\n").useEncoder((CsvEncoder)new GuardrailsCsvEncoder()).build()));
        }
    }

    public void write(String[] row, Boolean applyQuotes) throws IOException {
        if (this.isCsvReplacementEnabled()) {
            this.openCsvWriter.writeNext(row, applyQuotes.booleanValue());
            this.openCsvWriter.flush();
        } else {
            this.superCsvWriter.write(row);
            this.superCsvWriter.flush();
        }
    }

    public boolean isCsvReplacementEnabled() {
        return this.migrationDarkFeaturesManager.isCsvReplacementEnabled();
    }

    public void flush() throws IOException {
        if (this.isCsvReplacementEnabled()) {
            this.openCsvWriter.flush();
        } else {
            this.superCsvWriter.flush();
        }
    }
}

