/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.analytics.events.TimerMetricEvent;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.service.analytics.AnalyticsMessageHandler;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class MapiAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final PluginVersionManager pluginVersionManager;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public MapiAnalyticsEventBuilder(AnalyticsEventBuilderUtil analyticsEventBuilderUtil, SENSupplier senSupplier, PluginVersionManager pluginVersionManager) {
        this(analyticsEventBuilderUtil, senSupplier, pluginVersionManager, Instant::now);
    }

    MapiAnalyticsEventBuilder(AnalyticsEventBuilderUtil analyticsEventBuilderUtil, SENSupplier senSupplier, PluginVersionManager pluginVersionManager, Supplier<Instant> instantSupplier) {
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
        this.senSupplier = senSupplier;
        this.pluginVersionManager = pluginVersionManager;
        this.instantSupplier = instantSupplier;
    }

    public EventDto buildMapiJobOperationalEvent(String mapiJobId, Optional<PlanDto> planDto, int statusCode, String errorReason, long totalTime, String action) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"planId", (Object)planDto.map(PlanDto::getId).orElse(""));
        attributes.put((Object)"migrationId", (Object)planDto.map(PlanDto::getMigrationId).orElse(""));
        attributes.put((Object)"statusCode", (Object)statusCode);
        attributes.put((Object)"reason", (Object)AnalyticsMessageHandler.messageHandler(errorReason));
        attributes.put((Object)"timeTaken", (Object)Long.toString(totalTime));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).actionSubject("mapiJob", mapiJobId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildMapiJobTimerMetricEvent(int statusCode, Long totalTime, String metricName) {
        HashMap<String, String> tagsMap = new HashMap<String, String>();
        tagsMap.put("statusCode", Integer.toString(statusCode));
        tagsMap.put("isInternalSen", this.analyticsEventBuilderUtil.isInternalSenStr());
        tagsMap.put("pluginVersion", this.pluginVersionManager.getPluginVersion());
        return ((TimerMetricEvent.Builder)new TimerMetricEvent.Builder(metricName, totalTime).tags(tagsMap)).build();
    }
}

