/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.util;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.guardrails.GuardrailsCsvEncoder;
import com.atlassian.migration.agent.service.util.PreferenceType;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class CsvReaderFacade {
    private CSVReader openCsvReader;
    private CsvListReader superCsvReader;
    private MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public CsvReaderFacade(MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public void initialise(Reader reader, PreferenceType preferenceType) {
        if (this.migrationDarkFeaturesManager.isCsvReplacementEnabled()) {
            this.openCsvReader = new CSVReader(reader);
        } else {
            this.superCsvReader = preferenceType == PreferenceType.DEFAULT ? new CsvListReader(reader, new CsvPreference.Builder(CsvPreference.EXCEL_PREFERENCE).useQuoteMode((csvColumn, csvContext, csvPreference) -> Objects.nonNull(csvColumn)).build()) : (preferenceType == PreferenceType.STANDARD ? new CsvListReader(reader, CsvPreference.STANDARD_PREFERENCE) : new CsvListReader(reader, new CsvPreference.Builder('\"', 44, "\r\n").useEncoder((CsvEncoder)new GuardrailsCsvEncoder()).build()));
        }
    }

    public String[] read() throws CsvValidationException, IOException {
        if (this.migrationDarkFeaturesManager.isCsvReplacementEnabled()) {
            return this.openCsvReader.readNext();
        }
        List result = this.superCsvReader.read();
        return result != null ? result.toArray(new String[0]) : null;
    }
}

