/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.web;

import com.atlassian.cmpt.domain.Edition;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.CloudType;
import com.atlassian.migration.agent.mma.service.MigrationMetadataAggregatorService;
import com.atlassian.migration.agent.rest.GenerateCloudSiteSetupUrlDto;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.cloud.LegalService;
import com.atlassian.migration.agent.service.cloud.NonceService;
import com.atlassian.migration.agent.service.impl.DetectedUserEmailAnalyticsService;
import com.atlassian.migration.agent.service.prc.PrcClientService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.xwork.ParameterSafe;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
public class SaveCloudSiteAction
extends ConfluenceActionSupport {
    private static final String NONCE_ERROR_CODE = "nonceError-";
    private static final String AUTH_ERROR_CODE = "authError-";
    private static final String SUCCESS = "success-";
    private static final String CLOUD_CONNECT_ERROR_CODE = "cloudConnectError-";
    private String cloudUrl;
    private String cloudId;
    private String containerToken;
    private String nonce;
    private String cloudEdition;
    private String redirectTo;
    private String planId;
    private String cloudType;
    private final transient NonceService nonceService;
    private final transient CloudSiteService cloudSiteService;
    private final transient LegalService legalService;
    private final transient DetectedUserEmailAnalyticsService detectedUserEmailAnalyticsService;
    private final transient MigrationMetadataAggregatorService migrationMetadataAggregatorService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final PrcClientService prcClientService;
    private static final Logger log = LoggerFactory.getLogger(SaveCloudSiteAction.class);

    SaveCloudSiteAction(NonceService nonceService, CloudSiteService cloudSiteService, LegalService legalService, DetectedUserEmailAnalyticsService detectedUserEmailAnalyticsService, MigrationMetadataAggregatorService migrationMetadataAggregatorService, MigrationDarkFeaturesManager migrationDarkFeaturesManager, PrcClientService prcClientService) {
        this.nonceService = nonceService;
        this.cloudSiteService = cloudSiteService;
        this.legalService = legalService;
        this.detectedUserEmailAnalyticsService = detectedUserEmailAnalyticsService;
        this.migrationMetadataAggregatorService = migrationMetadataAggregatorService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.prcClientService = prcClientService;
    }

    public String execute() {
        if (Stream.of(this.cloudUrl, this.cloudId, this.containerToken, this.nonce, this.redirectTo, this.cloudType).anyMatch(Objects::isNull)) {
            return AUTH_ERROR_CODE + this.redirectOrDefault(this.redirectTo);
        }
        if (!this.nonceService.validateAndDeleteNonce(this.nonce)) {
            return NONCE_ERROR_CODE + this.redirectTo;
        }
        Optional<Edition> edition = Optional.ofNullable(this.cloudEdition).map(s -> Edition.getByKey((String)this.cloudEdition));
        this.cloudSiteService.createOrUpdate(this.cloudId, this.cloudUrl, this.containerToken, edition, CloudType.valueOf(this.cloudType));
        this.detectedUserEmailAnalyticsService.triggerForCloudId(this.cloudId);
        try {
            if (this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
                this.prcClientService.attachUntilTokenExpiry(this.cloudUrl);
                this.migrationMetadataAggregatorService.upsertServerInstanceCloudSitePairInMMA(this.containerToken, this.cloudId);
            }
        }
        catch (Exception e) {
            log.error("Error while connecting to MMA: [{}]\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
        }
        this.legalService.rememberLegalOptIn();
        return SUCCESS + this.redirectTo;
    }

    private String redirectOrDefault(String redirectTo) {
        return StringUtils.isNotEmpty((CharSequence)redirectTo) ? redirectTo : GenerateCloudSiteSetupUrlDto.DEFAULT_REDIRECT;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    @ParameterSafe
    public void setPlanId(String planId) {
        this.planId = planId;
    }

    @ParameterSafe
    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    @ParameterSafe
    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    @ParameterSafe
    public void setContainerToken(String containerToken) {
        this.containerToken = containerToken;
    }

    @ParameterSafe
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    @ParameterSafe
    public void setCloudEdition(String cloudEdition) {
        this.cloudEdition = cloudEdition;
    }

    @ParameterSafe
    public void setRedirectTo(String redirectTo) {
        this.redirectTo = redirectTo;
    }

    @ParameterSafe
    public void setCloudType(String cloudType) {
        this.cloudType = cloudType;
    }

    public String getCloudType() {
        return this.cloudType;
    }
}

