/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;

public class UserMigrationStepAnalyticsEventBuilder {
    private final PluginVersionManager pluginVersionManager;
    private final Supplier<Instant> instantSupplier;
    private final SENSupplier senSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public UserMigrationStepAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, SENSupplier senSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this(pluginVersionManager, Instant::now, senSupplier, analyticsEventBuilderUtil);
    }

    UserMigrationStepAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, Supplier<Instant> instantSupplier, SENSupplier senSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.pluginVersionManager = pluginVersionManager;
        this.instantSupplier = instantSupplier;
        this.senSupplier = senSupplier;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    public EventDto buildUserMigrationStartEvent(Step step, long startTime, ImmutableMap.Builder<String, Object> attributes) {
        GenericOperationalEvent.Builder stepBuilder = this.analyticsEventBuilderUtil.getBuilderStartedEvent(step, startTime);
        stepBuilder.withAttributes((Map)attributes.build());
        return stepBuilder.build();
    }

    public EventDto buildUserStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String planId, boolean scoped) {
        return this.buildUserStepTimerEvent(stepSuccessful, totalTime, action, planId, scoped, -1, -1);
    }

    public EventDto buildUserStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String planId, boolean scoped, int userCount, int groupCount) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"stepSuccessful", (Object)stepSuccessful);
        attributes.put((Object)"userCount", (Object)String.valueOf(userCount));
        attributes.put((Object)"groupCount", (Object)String.valueOf(groupCount));
        attributes.put((Object)"timeTaken", (Object)Long.toString(totalTime));
        attributes.put((Object)"scoped", (Object)scoped);
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).actionSubject("plan", planId)).withAttributes((Map)attributes.build())).build();
    }
}

