/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.CounterMetricEvent;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.analytics.events.GenericTrackEvent;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.UsageInfo;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.migration.agent.dto.ConfluenceSpaceTaskDto;
import com.atlassian.migration.agent.dto.MigrateGlobalEntitiesTaskDto;
import com.atlassian.migration.agent.dto.MigrateUsersTaskDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.dto.util.PlanDtoUtil;
import com.atlassian.migration.agent.dto.util.UserMigrationType;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.MigrationTag;
import com.atlassian.migration.agent.mapi.MigrationCreator;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.GlobalEntitiesStats;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.model.stats.UsersGroupsStats;
import com.atlassian.migration.agent.service.MigrationMetric;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.analytics.FeatureFlagActionSubject;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.VisibleForTesting;

public class PlanLevelAnalyticsBuilder {
    private final PluginVersionManager pluginVersionManager;
    private final SystemInformationService systemInformationService;
    private final Supplier<Instant> instantSupplier;
    private final SENSupplier senSupplier;
    private final StatisticsService statisticsService;
    private final MigrationTimeEstimationUtils migrationTimeEstimationUtils;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public PlanLevelAnalyticsBuilder(PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService, SENSupplier senSupplier, StatisticsService statisticsService, MigrationTimeEstimationUtils migrationTimeEstimationUtils, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this(pluginVersionManager, systemInformationService, Instant::now, senSupplier, statisticsService, migrationTimeEstimationUtils, analyticsEventBuilderUtil);
    }

    @VisibleForTesting
    PlanLevelAnalyticsBuilder(PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService, Supplier<Instant> instantSupplier, SENSupplier senSupplier, StatisticsService statisticsService, MigrationTimeEstimationUtils migrationTimeEstimationUtils, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.pluginVersionManager = pluginVersionManager;
        this.systemInformationService = systemInformationService;
        this.instantSupplier = instantSupplier;
        this.senSupplier = senSupplier;
        this.statisticsService = statisticsService;
        this.migrationTimeEstimationUtils = migrationTimeEstimationUtils;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    EventDto buildCreatedPlanAnalyticsEvent(long now, PlanDto planDto, long numberOfSpaces, long estimatedTime, ConfluenceUser confluenceUser, Optional<String> mapiJobId) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"status", (Object)planDto.getProgress().getStatus());
        attributes.put((Object)"numberOfSpaces", (Object)Long.toString(numberOfSpaces));
        attributes.put((Object)"estimatedTime", (Object)Long.toString(estimatedTime));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"migrationTag", (Object)planDto.getMigrationTag());
        attributes.put((Object)"migrationCreator", (Object)planDto.getMigrationCreator());
        if (mapiJobId.isPresent()) {
            attributes.put((Object)"mapiJobId", (Object)mapiJobId.get());
        }
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action("created")).sen(this.senSupplier.get())).email(confluenceUser == null ? null : confluenceUser.getEmail())).source("reviewScreen")).actionSubject("plan", planDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildFeatureFlagsOperationalEvent(String enabledMigrationFeatures, FeatureFlagActionSubject actionSubject, String actionSubjectId) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"featureFlagKey", (Object)enabledMigrationFeatures);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("featureFlag")).sen(this.senSupplier.get())).actionSubject(actionSubject.getValue(), actionSubjectId)).withAttributes((Map)attributes.build())).build();
    }

    public List<EventDto> buildCreatePlanAndTasksAnalyticsEvents(PlanDto planDto, ConfluenceUser confluenceUser, Optional<String> mapiJobId) {
        long now = this.instantSupplier.get().toEpochMilli();
        LongAdder numberOfSpaces = new LongAdder();
        LongAdder estimatedTime = new LongAdder();
        ArrayList<EventDto> analyticsEventModels = new ArrayList<EventDto>();
        String planId = planDto.getId();
        planDto.getTasks().forEach(task -> {
            if (task instanceof ConfluenceSpaceTaskDto) {
                ConfluenceSpaceTaskDto confluenceSpaceTaskDto = (ConfluenceSpaceTaskDto)task;
                this.analyticsEventBuilderUtil.feedSpaceStatsIfPresent(confluenceSpaceTaskDto.getSpace(), spaceStats -> {
                    numberOfSpaces.increment();
                    long thisEstimatedTime = this.migrationTimeEstimationUtils.estimateSpaceMigrationTime(spaceStats.getSummary()).getSeconds();
                    estimatedTime.add(thisEstimatedTime);
                    analyticsEventModels.add(this.buildAddedSpaceAnalyticsEvent(now, planId, confluenceSpaceTaskDto, thisEstimatedTime, (SpaceStats)spaceStats, confluenceUser));
                });
            } else if (task instanceof MigrateUsersTaskDto) {
                MigrateUsersTaskDto migrateUsersTaskDto = (MigrateUsersTaskDto)task;
                List<String> spaceKeys = PlanDtoUtil.getSpaceKeysForScope(planDto);
                UserMigrationType userMigrationType = migrateUsersTaskDto.isScoped() ? UserMigrationType.SCOPED : UserMigrationType.ALL;
                UsersGroupsStats usersStats = this.statisticsService.getUsersGroupsStatistics(userMigrationType, spaceKeys, PlanDtoUtil.getGlobalEntityType(planDto));
                estimatedTime.add(usersStats.getTotalMigrationTime().getSeconds());
                analyticsEventModels.add(this.buildAddedUserGroupsAnalyticsEvent(now, planId, migrateUsersTaskDto, usersStats.getTotalMigrationTime().getSeconds(), usersStats, confluenceUser));
            } else if (task instanceof MigrateGlobalEntitiesTaskDto) {
                MigrateGlobalEntitiesTaskDto migrateGlobalEntitiesTaskDto = (MigrateGlobalEntitiesTaskDto)task;
                GlobalEntitiesStats globalEntitiesStats = this.statisticsService.getGlobalEntitiesStatistics(planId);
                estimatedTime.add(migrateGlobalEntitiesTaskDto.getMigrationEstimateSeconds());
                analyticsEventModels.add(this.buildAddedGlobalEntitiesAnalyticsEvent(now, planId, migrateGlobalEntitiesTaskDto, migrateGlobalEntitiesTaskDto.getMigrationEstimateSeconds(), globalEntitiesStats, confluenceUser));
            }
        });
        analyticsEventModels.add(0, this.buildCreatedPlanAnalyticsEvent(now, planDto, numberOfSpaces.longValue(), estimatedTime.longValue(), confluenceUser, mapiJobId));
        return analyticsEventModels;
    }

    EventDto buildAddedSpaceAnalyticsEvent(long now, String planId, ConfluenceSpaceTaskDto confluenceSpaceTaskDto, long estimatedTime, SpaceStats spaceStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        this.analyticsEventBuilderUtil.feedSpaceIdIfPresent(spaceStats.getSpaceKey(), spaceId -> attributes.put((Object)"spaceId", (Object)Long.toString(spaceId)));
        attributes.put((Object)"planId", (Object)planId);
        attributes.put((Object)"status", (Object)confluenceSpaceTaskDto.getProgress().getStatus());
        attributes.put((Object)"type", (Object)"confluence-space");
        attributes.put((Object)"estimatedTime", (Object)Long.toString(estimatedTime));
        ContentSummary contentSummary = spaceStats.getSummary();
        attributes.put((Object)"numberOfPages", (Object)Long.toString(contentSummary.getNumberOfPages()));
        attributes.put((Object)"numberOfBlogs", (Object)Long.toString(contentSummary.getNumberOfBlogs()));
        attributes.put((Object)"numberOfTeamCalendars", (Object)Long.toString(contentSummary.getNumberOfTeamCalendars() != null ? contentSummary.getNumberOfTeamCalendars() : 0L));
        attributes.put((Object)"numberOfDrafts", (Object)Long.toString(contentSummary.getNumberOfDrafts()));
        attributes.put((Object)"numberOfAttachments", (Object)Long.toString(contentSummary.getNumberOfAttachments()));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action("added")).sen(this.senSupplier.get())).email(confluenceUser == null ? null : confluenceUser.getEmail())).source("reviewScreen")).actionSubject("object", confluenceSpaceTaskDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    EventDto buildAddedUserGroupsAnalyticsEvent(long now, String planId, MigrateUsersTaskDto migrateUsersTaskDto, long estimatedTime, UsersGroupsStats usersStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"planId", (Object)planId);
        attributes.put((Object)"status", (Object)migrateUsersTaskDto.getProgress().getStatus());
        attributes.put((Object)"type", (Object)"users-and-groups");
        attributes.put((Object)"estimatedTime", (Object)Long.toString(estimatedTime));
        attributes.put((Object)"numberOfUsers", (Object)Long.toString(usersStats.getNumberOfUsers()));
        attributes.put((Object)"numberOfGroups", (Object)Long.toString(usersStats.getNumberOfGroups()));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action("added")).sen(this.senSupplier.get())).email(confluenceUser == null ? null : confluenceUser.getEmail())).source("reviewScreen")).actionSubject("object", migrateUsersTaskDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    private EventDto buildAddedGlobalEntitiesAnalyticsEvent(long now, String planId, MigrateGlobalEntitiesTaskDto migrateGlobalEntitiesTaskDto, long estimatedTime, GlobalEntitiesStats globalEntitiesStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"planId", (Object)planId);
        attributes.put((Object)"status", (Object)migrateGlobalEntitiesTaskDto.getProgress().getStatus());
        attributes.put((Object)"type", (Object)"GLOBAL_ENTITIES");
        this.analyticsEventBuilderUtil.addGlobalEntitiesStatsToAttributes(attributes, globalEntitiesStats);
        attributes.put((Object)"estimatedTime", (Object)Long.toString(estimatedTime));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action("added")).sen(this.senSupplier.get())).email(confluenceUser == null ? null : confluenceUser.getEmail())).source("reviewScreen")).actionSubject("object", migrateGlobalEntitiesTaskDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildStartPlanAnalyticsEvent(PlanDto planDto) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"status", (Object)"RUNNING");
        attributes.put((Object)"numberOfObjects", (Object)Long.toString(planDto.getTasks().size()));
        attributes.put((Object)"startTime", (Object)planDto.getProgress().getStartTime());
        attributes.put((Object)"migrationId", (Object)planDto.getMigrationId());
        attributes.put((Object)"tenantId", (Object)planDto.getCloudSite().getCloudId());
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        Duration userGroupMigrationTime = MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(usageInfo.getLocalUsers(), usageInfo.getLocalGroups());
        List<String> spaceKeys = this.getSpaceKeysByPlan(planDto);
        this.analyticsEventBuilderUtil.feedSpaceStatsCollectionIfPresent(spaceKeys, spaceStatsCollection -> {
            long spaceMigrationTime = this.calculateSpaceMigrationTime((Collection<SpaceStats>)spaceStatsCollection);
            attributes.put((Object)"estimatedTime", (Object)Long.toString(userGroupMigrationTime.getSeconds() + spaceMigrationTime));
        });
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        long freeHeapSize = Runtime.getRuntime().freeMemory();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"configuredHeapSize", (Object)Long.toString(configuredHeapSize));
        attributes.put((Object)"freeHeapSize", (Object)Long.toString(freeHeapSize));
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("started")).sen(this.senSupplier.get())).actionSubject("plan", planDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    private List<String> getSpaceKeysByPlan(PlanDto planDto) {
        return planDto.getTasks().stream().filter(ConfluenceSpaceTaskDto.class::isInstance).map(taskDto -> ((ConfluenceSpaceTaskDto)taskDto).getSpace()).collect(Collectors.toList());
    }

    private long calculateSpaceMigrationTime(Collection<SpaceStats> spaceStatsCollection) {
        List<ContentSummary> spaceSummaries = spaceStatsCollection.stream().map(SpaceStats::getSummary).collect(Collectors.toList());
        return this.migrationTimeEstimationUtils.estimateTotalSpaceMigrationTime(spaceSummaries).getSeconds();
    }

    public EventDto buildUpdatedPlanStatusAnalyticEvent(PlanDto planDto, ProgressDto.Status fromStatus) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"oldStatus", (Object)fromStatus.name());
        attributes.put((Object)"newStatus", (Object)planDto.getProgress().getStatus().name());
        attributes.put((Object)"migrationId", (Object)planDto.getMigrationId());
        attributes.put((Object)"tenantId", (Object)planDto.getCloudSite().getCloudId());
        List<String> spaceKeys = this.getSpaceKeysByPlan(planDto);
        this.analyticsEventBuilderUtil.feedSpaceStatsCollectionIfPresent(spaceKeys, spaceStatsCollection -> {
            long totalAttachmentsSize = spaceStatsCollection.stream().mapToLong(spaceStat -> {
                Long totalSize = spaceStat.getSummary().getAttachments().getTotalSize();
                if (totalSize != null) {
                    return totalSize;
                }
                return 0L;
            }).sum();
            attributes.put((Object)"totalAttachmentsSize", (Object)totalAttachmentsSize);
        });
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("updated")).sen(this.senSupplier.get())).actionSubject("planStatus", planDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildCompletedPlanAnalyticsEvent(PlanDto planDto) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        long freeHeapSize = Runtime.getRuntime().freeMemory();
        attributes.put((Object)"status", (Object)planDto.getProgress().getStatus());
        attributes.put((Object)"numberOfObjects", (Object)Long.toString(planDto.getTasks().size()));
        Map<String, Long> taskCounts = this.getTaskCounts(planDto);
        attributes.putAll(taskCounts);
        Duration userGroupMigrationTime = this.getUserGroupMigrationTime(planDto);
        long spaceMigrationTime = PlanDtoUtil.calculateTotalSpaceTaskDuration(planDto);
        attributes.put((Object)"estimatedTime", (Object)Long.toString(userGroupMigrationTime.plus(MigrationTimeEstimationUtils.getBaseMigrationTime()).getSeconds() + spaceMigrationTime));
        attributes.put((Object)"actualTime", (Object)Long.toString(PlanDtoUtil.totalElapsedTimeInSeconds(planDto)));
        attributes.put((Object)"startTime", (Object)planDto.getProgress().getStartTime());
        attributes.put((Object)"stopTime", (Object)planDto.getProgress().getEndTime());
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"migrateAllUsers", (Object)(!PlanDtoUtil.hasScopedUserTask(planDto) ? 1 : 0));
        attributes.put((Object)"attachmentsOnly", (Object)PlanDtoUtil.containsAttachmentsOnlyTask(planDto));
        attributes.put((Object)"migrateUserType", (Object)PlanDtoUtil.userMigrationType(planDto).name());
        attributes.put((Object)"migrationId", (Object)planDto.getMigrationId());
        attributes.put((Object)"tenantId", (Object)planDto.getCloudSite().getCloudId());
        attributes.put((Object)"configuredHeapSize", (Object)Long.toString(configuredHeapSize));
        attributes.put((Object)"freeHeapSize", (Object)Long.toString(freeHeapSize));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("completed")).sen(this.senSupplier.get())).actionSubject("plan", planDto.getId())).source("monitorScreen")).withAttributes((Map)attributes.build())).build();
    }

    private Map<String, Long> getTaskCounts(PlanDto planDto) {
        return planDto.getTasks().stream().collect(Collectors.groupingBy(task -> String.format("%s%sTaskCount", task.isSuccessful() ? "successful" : "failed", task.getTaskTypeSingularTitleCase()), Collectors.counting()));
    }

    public EventDto buildPlatformPlanCompletionOperationalEvent(PlanDto planDto, String migrationScopeId, ExecutionStatus status) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getSourceDestinationLocation(planDto.getCloudSite().getCloudId());
        attributes.put((Object)"productFamily", (Object)"CONFLUENCE");
        attributes.put((Object)"migrationType", (Object)"S2C_MIGRATION");
        attributes.put((Object)"platformEvent", (Object)true);
        attributes.put((Object)"migrationId", (Object)planDto.getMigrationId());
        attributes.put((Object)"migrationScopeId", (Object)migrationScopeId);
        attributes.put((Object)"planId", (Object)planDto.getId());
        attributes.put((Object)"migrationTag", (Object)planDto.getMigrationTag());
        attributes.put((Object)"migrationCreator", (Object)planDto.getMigrationCreator());
        attributes.put((Object)"version", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"status", (Object)this.analyticsEventBuilderUtil.convertToProgressStatus(status).getStatusName());
        this.analyticsEventBuilderUtil.addConfluenceAndDBVersionInAttributes(attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("completed")).actionSubject("migration", planDto.getMigrationId())).contextContainer("migration", planDto.getMigrationId())).cloudId(planDto.getCloudSite().getCloudId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPlatformPlanCompletionMetricEvent(ExecutionStatus status, MigrationTag migrationTag, MigrationCreator migrationCreator) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        Map<String, String> tagsMap = this.analyticsEventBuilderUtil.buildPlatformCounterMetricCommonTags(status, migrationTag);
        attributes.put((Object)"platformEvent", (Object)true);
        tagsMap.put("migrationCreator", migrationCreator.name());
        tagsMap.put("version", this.pluginVersionManager.getPluginVersion());
        return ((CounterMetricEvent.Builder)((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.MIGRATIONS_OVERALL_SUCCESS_RATE.metricName).withAttributes((Map)attributes.build())).tags(tagsMap)).build();
    }

    private Duration getUserGroupMigrationTime(PlanDto planDto) {
        if (PlanDtoUtil.containsUsersGroupsTask(planDto)) {
            return this.getUserGroupMigrationTimeWithUserTask(planDto);
        }
        return Duration.ZERO;
    }

    private Duration getUserGroupMigrationTimeWithUserTask(PlanDto planDto) {
        if (PlanDtoUtil.hasScopedUserTask(planDto)) {
            UsersGroupsStats stats = this.statisticsService.getUsersGroupsStatistics(PlanDtoUtil.userMigrationType(planDto), PlanDtoUtil.getSpaceKeys(planDto), PlanDtoUtil.getGlobalEntityType(planDto));
            return MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(stats.getNumberOfUsers(), stats.getNumberOfGroups());
        }
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        return MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(usageInfo.getLocalUsers(), usageInfo.getLocalGroups());
    }
}

