/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.portfolioanalyzer.service;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.apache.commons.lang3.tuple.Pair;

public class MacrosBySpaceIdSupplier
implements Supplier<Map<Long, Set<String>>> {
    private final EntityManagerTemplate template;
    private final String query;

    public MacrosBySpaceIdSupplier(BootstrapManager bootstrapManager, EntityManagerTemplate entityManagerTemplate) {
        this.template = entityManagerTemplate;
        ApplicationConfiguration applicationConfig = bootstrapManager.getApplicationConfig();
        String dialect = (String)applicationConfig.getProperty((Object)"hibernate.dialect");
        String emptyString = dialect.toLowerCase().contains("oracle") ? "' '" : "''";
        this.query = "select COALESCE(c.spaceId, cc.spaceId), cp.stringval from ContentProperty cp join Content c on c.id = cp.content.id left join Content cc ON cc.id = c.container.id  where c.previousVersion is null and cp.name = 'macroNames' and cp.stringval is not null and cp.stringval != " + emptyString;
    }

    @Override
    public Map<Long, Set<String>> get() {
        return this.template.query(Tuple.class, this.query).list().stream().map(it -> Pair.of((Object)it.get(0, Long.class), (Object)it.get(1, String.class))).filter(it -> it.getKey() != null).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
    }
}

