/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.app.DefaultAppMigrationServiceClient;
import javax.persistence.NoResultException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppCancellationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppCancellationService.class);
    private final PluginTransactionTemplate ptx;
    private final DefaultAppMigrationServiceClient appMigrationServiceClient;
    private final PlanStore planStore;

    public AppCancellationService(PluginTransactionTemplate ptx, DefaultAppMigrationServiceClient appMigrationServiceClient, PlanStore planStore) {
        this.ptx = ptx;
        this.appMigrationServiceClient = appMigrationServiceClient;
        this.planStore = planStore;
    }

    public void cancelAppMigration(String planId, String containerId, String message) {
        log.info("Cancelling app migration for planId: {} containerId:{} with message:{}", new Object[]{planId, containerId, message});
        this.ptx.read(() -> {
            try {
                Plan plan = this.planStore.getPlan(planId);
                this.appMigrationServiceClient.cancelLatestTransfer(plan.getCloudSite().getCloudId(), containerId, message);
            }
            catch (NoResultException e) {
                throw new IllegalArgumentException("planId not found");
            }
        });
    }
}

