/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.CommonBeanConfiguration;
import com.atlassian.migration.agent.newexport.TemplatedQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.guardrails.queries.ExampleDataBuilder;
import com.atlassian.migration.agent.store.guardrails.queries.GuardrailsQueries;
import com.atlassian.migration.agent.store.guardrails.queries.ListQuery;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.impl.DialectResolver;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Import(value={CommonBeanConfiguration.class})
@Configuration
public class GuardrailsListQueriesConfiguration {
    public static final String ATTACHMENT_COUNT = "attachment_count";
    public static final String STATUS = "status";
    public static final String CURRENT = "current";
    @Autowired
    EntityManagerTemplate tmpl;
    @Autowired
    DialectResolver dialectResolver;

    @Bean
    public ListQuery currentAttPerPageQuery() {
        return new ListQuery(QueryIds.CURRENT_ATT_PER_PAGE, this.tmpl, "select content.container.id as page_id, count(*) as attachment_count from Content content where content.type = 'ATTACHMENT'  and content.container.id in    (select c.id from Content c where c.type in ('PAGE', 'BLOGPOST') and c.previousVersion is null and c.status in ('current', 'draft'))    and content.previousVersion is null    and content.status = 'current' group by content.container.id order by attachment_count DESC", AbstractQuery.QueryBuilderOptions.max(100), ExampleDataBuilder.columns("page_id", ATTACHMENT_COUNT).addRow(195133633L, 300).addRow(247332908, 130));
    }

    public ListQuery findRecentlyUsedSpacesQuery() {
        return new ListQuery(QueryIds.RECENTLY_USED_SPACES, this.tmpl, "select s.key as spacekey, s.status as spacestatus, s.type as spacetype, count(*) as numberOfContent, (select count(*) from Content nc where nc.spaceId = s.id and nc.lastModDate > current_date - 180) as spaceLastModified, (select count(s) from s where s.key in (select spaceKey from RecentlyViewed group by contentId, spaceKey having max(lastViewDate) > current_date - 180)) as numberOfUniqueUsersVisited FROM Content c join Space s on c.spaceId = s.id where c.type = 'PAGE' and c.previousVersion is null and c.status = 'current' group by s.id, s.key, s.name, s.status, s.type", ExampleDataBuilder.columns("spacekey", "spacestatus", "spacetype", "numberOfContent", "spaceLastModified", "numberOfUniqueUsersVisited").addRow("TEST", "CURRENT", "global", 5L, 2L, 100L));
    }

    @Bean
    public ListQuery sizeOfDBQuery() {
        return this.create(QueryIds.SIZE_OF_DB, GuardrailsQueries.SIZE_OF_DB_QUERY, ExampleDataBuilder.columns("database", "size").addRow("public", 1489L));
    }

    @Bean
    public ListQuery groupsPerUserQuery() {
        return new ListQuery(QueryIds.GROUPS_PER_USER, this.tmpl, "select count(parent) as number_of_groups, child as user_id from CrowdMembership cm group by child order by number_of_groups desc", AbstractQuery.QueryBuilderOptions.max(100), ExampleDataBuilder.columns("number_of_groups", "user_id").addRow(558, 676233217).addRow(507, 309231646));
    }

    @Bean
    public ListQuery totalBlogpostsQuery() {
        return this.create(QueryIds.TOTAL_BLOGPOSTS, "select status as status, count(*) as blogpost_count from Content where previousVersion is null and type = 'BLOGPOST' group by status", ExampleDataBuilder.columns(STATUS, "blogpost_count").addRow(CURRENT, 273).addRow("deleted", 2).addRow("draft", 105));
    }

    @Bean
    public ListQuery sizeOfTablesQuery() {
        return this.create(QueryIds.SIZE_OF_TABLES, GuardrailsQueries.SIZE_OF_TABLES_QUERY, ExampleDataBuilder.columns("database", "table", "size").addRow("1234", "AO_C77861_AUDIT_ENTITY", new BigDecimal("3.05")).addRow("2345", "cwd_membership", new BigDecimal("0.05")));
    }

    @Bean
    public ListQuery numberOfSpacesPerSpaceTypeQuery() {
        return this.create(QueryIds.NUMBER_OF_SPACES_PER_SPACETYPE, "select s.type as type, count(*) as TOTAL_SPACE_TYPE from Space s where s.type is not null group by s.type", ExampleDataBuilder.columns("type", "TOTAL_SPACE_TYPE").addRow("personal", 104).addRow("global", 659));
    }

    @Bean
    public ListQuery numberOfSpacesQuery() {
        return this.create(QueryIds.NUMBER_OF_SPACES, "select status as status, count(*) as space_count from Space group by status", ExampleDataBuilder.columns(STATUS, "space_count").addRow("ARCHIVED", 17).addRow("CURRENT", 22));
    }

    @Bean
    public ListQuery totalPagesQuery() {
        return this.create(QueryIds.TOTAL_PAGES, "select status as status, count(*) as page_count from Content where previousVersion is null and type = 'PAGE' group by status", ExampleDataBuilder.columns(STATUS, "page_count").addRow(CURRENT, 11689).addRow("draft", 5043));
    }

    @Bean
    public ListQuery personalSpacesForInactiveUsersQuery() {
        return this.create(QueryIds.PERSONAL_SPACES_INACTIVE_USERS, "select s.id as space_id from Space s join UserMapping u ON s.creator = u.userKey join CrowdUser c ON c.lowerUsername = u.lowerUsername where s.key like '%~%' AND c.active = 'F'", ExampleDataBuilder.columns("space_id").addRow(0x190001).addRow(10649603));
    }

    @Bean
    public ListQuery totalAttachmentsPerPageQuery() {
        return new ListQuery(QueryIds.TOTAL_ATTACHMENTS_PER_PAGE, this.tmpl, "select content.container.id as page_id, count(*) as attachment_count, content.status as attachment_status from Content content where content.type = 'ATTACHMENT' and content.container.id in (select c.id from Content c where c.type in ('PAGE', 'BLOGPOST') and c.status in ('current', 'draft') and c.previousVersion is null) and content.previousVersion is null group by content.container.id, content.status order by attachment_count desc", AbstractQuery.QueryBuilderOptions.max(100), ExampleDataBuilder.columns("page_id", ATTACHMENT_COUNT, "attachment_status").addRow(195133673, 200, CURRENT).addRow(233472071, 64, CURRENT));
    }

    @Bean
    public ListQuery totalAttachmentsPerSpaceQuery() {
        return new ListQuery(QueryIds.TOTAL_ATTACHMENTS_PER_SPACE, this.tmpl, "select content.spaceId as space_id, count(content.id) as attachment_count \n from Content content \n where content.type = 'ATTACHMENT'\n group by content.spaceId \n order by attachment_count DESC", AbstractQuery.QueryBuilderOptions.max(100), ExampleDataBuilder.columns("space_id", ATTACHMENT_COUNT).addRow(195133673, 200).addRow(233472071, 64));
    }

    @Bean
    public ListQuery totalPagesPerVersionQuery() {
        return new ListQuery(QueryIds.TOTAL_PAGES_PER_VERSION, this.tmpl, "select version as version, count(*) as page_count from Content where type in ('PAGE', 'BLOGPOST') and status in ('current', 'draft') group by version order by page_count desc", AbstractQuery.QueryBuilderOptions.max(100), ExampleDataBuilder.columns("version", "page_count").addRow(1, 200).addRow(2, 123));
    }

    private ListQuery create(QueryIds queryId, String query, ExampleDataBuilder builder) {
        return new ListQuery(queryId, this.tmpl, query, builder);
    }

    private ListQuery create(QueryIds queryId, TemplatedQuery query, ExampleDataBuilder builder) {
        return new ListQuery(queryId, this.tmpl, this.query(query), true, builder);
    }

    private String query(TemplatedQuery query) {
        return query.query(this.dialectResolver.getDbType());
    }
}

