/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.GrResult;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentResult;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.ExampleDataBuilder;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.QueryBuilder;
import java.util.Collections;
import java.util.List;
import javax.persistence.Tuple;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractQuery<T extends GrResult & L1AssessmentResult>
implements GrQuery<T>,
L1AssessmentQuery<T> {
    private final QueryIds queryId;
    protected final EntityManagerTemplate tmpl;
    protected final String query;
    protected final boolean nativeQuery;
    private final QueryBuilderOptions queryOptions;
    private final T example;

    protected AbstractQuery(QueryIds queryId, EntityManagerTemplate tmpl, String query, QueryBuilderOptions queryOptions, T example) {
        this(queryId, tmpl, query, false, queryOptions, example);
    }

    protected AbstractQuery(QueryIds queryId, EntityManagerTemplate tmpl, String query, T example) {
        this(queryId, tmpl, query, false, example);
    }

    protected AbstractQuery(QueryIds queryId, EntityManagerTemplate tmpl, String query, boolean nativeQuery, T example) {
        this(queryId, tmpl, query, nativeQuery, QueryBuilderOptions.EMPTY, example);
    }

    protected AbstractQuery(QueryIds queryId, EntityManagerTemplate tmpl, String query, boolean nativeQuery, QueryBuilderOptions queryOptions, T example) {
        this.queryId = queryId;
        this.tmpl = tmpl;
        this.query = query;
        this.nativeQuery = nativeQuery;
        this.queryOptions = queryOptions;
        this.example = example;
    }

    @Override
    public final String getQueryId() {
        return this.queryId.name();
    }

    protected List<Tuple> listTuples() {
        return StringUtils.isEmpty((CharSequence)this.query) ? Collections.emptyList() : this.prepareQuery(Tuple.class).list();
    }

    protected List<Tuple> formatResultIfNeeded(List<Tuple> original, boolean format) {
        return format ? GuardrailsUtil.formatResult(original) : original;
    }

    protected Tuple firstTupleResult(Tuple defaultValue) {
        return this.firstResult(Tuple.class, defaultValue);
    }

    protected <V> V firstResult(Class<V> cls, V defaultValue) {
        return StringUtils.isEmpty((CharSequence)this.query) ? defaultValue : this.prepareQuery(cls).first().orElse(defaultValue);
    }

    protected <V> V singleResult(Class<V> cls, V defaultValue) {
        return StringUtils.isEmpty((CharSequence)this.query) ? defaultValue : this.prepareQuery(cls).single();
    }

    protected <V> QueryBuilder<V> prepareQuery(Class<V> cls) {
        QueryBuilder<V> builder = this.nativeQuery ? this.tmpl.nativeQuery(cls, this.query) : this.tmpl.query(cls, this.query);
        return this.queryOptions.apply(builder);
    }

    protected static ExampleDataBuilder example(String ... columns) {
        return ExampleDataBuilder.columns(columns);
    }

    @Override
    public T example() {
        return this.example;
    }

    public static interface QueryBuilderOptions {
        public static final QueryBuilderOptions EMPTY = new QueryBuilderOptions(){

            @Override
            public <V> QueryBuilder<V> apply(QueryBuilder<V> queryBuilder) {
                return queryBuilder;
            }
        };

        public <V> QueryBuilder<V> apply(QueryBuilder<V> var1);

        public static QueryBuilderOptions param(final String name, final Object value) {
            return new QueryBuilderOptions(){

                @Override
                public <V> QueryBuilder<V> apply(QueryBuilder<V> queryBuilder) {
                    return queryBuilder.param(name, value);
                }
            };
        }

        public static QueryBuilderOptions max(final int limit) {
            return new QueryBuilderOptions(){

                @Override
                public <V> QueryBuilder<V> apply(QueryBuilder<V> queryBuilder) {
                    return queryBuilder.max(limit);
                }
            };
        }
    }
}

