/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.service.guardrails.macro.DefaultMacroResultSetConverter;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentSupplier;
import com.atlassian.migration.agent.service.guardrails.macro.MacroTuple;
import com.atlassian.migration.agent.service.guardrails.macro.StaticMacroInformation;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroAssessmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MacroAssessmentService.class);
    private final SystemInformationService sysInfoService;
    private final Set<MacroAssessmentSupplier> macroAssessmentSuppliers;

    public MacroAssessmentService(SystemInformationService sysInfoService, Set<MacroAssessmentSupplier> macroAssessmentSuppliers) {
        this.sysInfoService = sysInfoService;
        this.macroAssessmentSuppliers = macroAssessmentSuppliers;
    }

    public MacroAssessmentResult assess() {
        Set<MacroTuple> macroTuples = this.macroAssessmentSuppliers.parallelStream().flatMap(mas -> mas.fetch().stream()).collect(Collectors.toSet());
        return new DefaultMacroResultSetConverter(new StaticMacroInformation(), this.sysInfoService).convert(macroTuples);
    }

    public MacroAssessmentResult example() {
        ImmutableSet macroTuples = ImmutableSet.of((Object)new MacroTuple((Long)123L, (Long)1L, (Long)15L, "html", "PAGE"), (Object)new MacroTuple((Long)124L, (Long)1L, (Long)15L, "html-include", "COMMENT"), (Object)new MacroTuple((Long)125L, (Long)1L, (Long)17L, "viewxls", "BLOGPOST"), (Object)new MacroTuple((Long)126L, (Long)2L, (Long)21L, "change-history", "PAGE"));
        return new DefaultMacroResultSetConverter(new StaticMacroInformation(), this.sysInfoService).convert((Set<MacroTuple>)macroTuples);
    }
}

