/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.external;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.guardrails.external.BubblesExternalJob;
import com.atlassian.migration.agent.service.guardrails.external.ExternalJob;
import com.atlassian.migration.agent.service.portfolioanalyzer.service.RelationsAnalyzerRunner;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ExternalJobsFactory {
    private final MigrationDarkFeaturesManager darkFeaturesManager;
    private final RelationsAnalyzerRunner relationsAnalyzerRunner;
    private final SystemInformationService systemInformationService;
    private final Path outputFilesDir;

    public ExternalJobsFactory(MigrationDarkFeaturesManager darkFeaturesManager, RelationsAnalyzerRunner relationsAnalyzerRunner, SystemInformationService systemInformationService, Path outputFilesDir) {
        this.darkFeaturesManager = darkFeaturesManager;
        this.relationsAnalyzerRunner = relationsAnalyzerRunner;
        this.systemInformationService = systemInformationService;
        this.outputFilesDir = outputFilesDir;
    }

    public List<ExternalJob> getExternalJobs() {
        ArrayList<ExternalJob> externalJobs = new ArrayList<ExternalJob>();
        if (this.darkFeaturesManager.isRelationsAnalysisDuringInstanceAssessmentEnabled()) {
            externalJobs.add(new BubblesExternalJob(this.relationsAnalyzerRunner, this.outputFilesDir, this.systemInformationService));
        }
        return externalJobs;
    }
}

