/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.dto.AppListenerIssueType;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.app.PluginManager;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.app.analytics.MultiPartUploadAnalyticEvent;
import com.atlassian.plugin.PluginInformation;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class AppsLevelAnalyticEventBuilder {
    private final SENSupplier senSupplier;
    private final PluginManager pluginManager;
    private final PluginVersionManager pluginVersionManager;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public AppsLevelAnalyticEventBuilder(AnalyticsEventBuilderUtil analyticsEventBuilderUtil, SENSupplier senSupplier, PluginManager pluginManager, PluginVersionManager pluginVersionManager) {
        this(analyticsEventBuilderUtil, senSupplier, pluginManager, pluginVersionManager, Instant::now);
    }

    @VisibleForTesting
    AppsLevelAnalyticEventBuilder(AnalyticsEventBuilderUtil analyticsEventBuilderUtil, SENSupplier senSupplier, PluginManager pluginManager, PluginVersionManager pluginVersionManager, Supplier<Instant> instantSupplier) {
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
        this.senSupplier = senSupplier;
        this.pluginManager = pluginManager;
        this.pluginVersionManager = pluginVersionManager;
        this.instantSupplier = instantSupplier;
    }

    public EventDto buildAppPartUploadEvent(MultiPartUploadAnalyticEvent multiPartUploadAnalyticEvent, Long time) {
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(time.longValue()).action("uploaded")).actionSubject("appDataPart")).source("appDataPartUploaded")).cloudId(multiPartUploadAnalyticEvent.getCloudId())).contextContainer("migrationId", multiPartUploadAnalyticEvent.getMigrationId())).withAttributes(this.getAttributesMap(multiPartUploadAnalyticEvent))).cloudId(multiPartUploadAnalyticEvent.getCloudId())).sen(this.senSupplier.get())).build();
    }

    public EventDto buildAppServerListenerIssueEvent(String appKey, AppListenerIssueType issueType) {
        PluginInformation pluginInfo = this.pluginManager.getPlugin(appKey).getPluginInformation();
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"appKey", (Object)appKey);
        attributes.put((Object)"appVersion", (Object)pluginInfo.getVersion());
        attributes.put((Object)"issueType", (Object)issueType.name());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("occurred")).sen(this.senSupplier.get())).actionSubject("appServerListenerIssue")).withAttributes((Map)attributes.build())).build();
    }

    @NotNull
    private HashMap<String, Object> getAttributesMap(@NotNull MultiPartUploadAnalyticEvent multPartUploadAnalyticEvent) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll((Map<String, Object>)this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes().build());
        attributes.put("transferId", multPartUploadAnalyticEvent.getTransferId());
        attributes.put("s3Key", multPartUploadAnalyticEvent.getS3Key());
        attributes.put("appKey", multPartUploadAnalyticEvent.getAppKey());
        attributes.put("contentMD5", multPartUploadAnalyticEvent.getMd5Sum());
        attributes.put("partIndex", multPartUploadAnalyticEvent.getIndex());
        attributes.put("sizeKb", multPartUploadAnalyticEvent.getSize());
        attributes.put("parallelMode", multPartUploadAnalyticEvent.getParallelMode());
        attributes.put("cachedUploadMode", multPartUploadAnalyticEvent.getCachedUploadMode());
        attributes.put("partUploadTimeSeconds", multPartUploadAnalyticEvent.getUploadToS3ElapsedTime());
        attributes.put("urlGenerateTimeSeconds", multPartUploadAnalyticEvent.getGetUrlElapsedTime());
        attributes.put("uploadTotalTimeSeconds", multPartUploadAnalyticEvent.getTotalElapsedTime());
        return attributes;
    }
}

