/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.ListQuery;
import com.atlassian.migration.agent.store.guardrails.results.ListResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;

public class MembershipPerGroupOverLimitQuery
extends ListQuery {
    private static final int GROUP_SIZE_LIMIT = 35000;
    private static final int LIMIT = 100;
    public static final String GROUP_ID = "group_id";
    public static final String MEMBERSHIP_COUNT = "membership_count";

    public MembershipPerGroupOverLimitQuery(EntityManagerTemplate tmpl) {
        super(QueryIds.GROUPS_WITH_35K_OR_MORE_USER_MEMBERSHIPS, tmpl, "select cg.id as group_id, count(cm.id) as membership_count from CrowdMembership cm join CrowdGroup cg on cg.id=cm.parent group by cg.lowerGroupName, cg.id order by membership_count desc", MembershipPerGroupOverLimitQuery.example(GROUP_ID, MEMBERSHIP_COUNT).addRow(778633284L, 13674L).addRow(897417465L, 13666L));
    }

    @Override
    public ListResult execute() {
        List<Tuple> tuples = this.listTuples();
        List<Tuple> filtered35K = tuples.stream().filter(i -> (Long)i.get(MEMBERSHIP_COUNT, Long.class) >= 35000L).collect(Collectors.toList());
        return filtered35K.isEmpty() ? new ListResult(tuples, 100) : new ListResult(filtered35K);
    }
}

