/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails;

import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import java.time.Instant;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class AssessmentStatus {
    @Nullable
    private final Instant completedDate;
    private final InstanceAssessmentStatus status;
    @Nullable
    private final String progress;

    private AssessmentStatus(@Nullable Instant completedDate, InstanceAssessmentStatus status, @Nullable String progress) {
        this.completedDate = completedDate;
        this.status = status;
        this.progress = progress;
    }

    public static AssessmentStatus newAssessment() {
        return new AssessmentStatus(null, InstanceAssessmentStatus.NEW, null);
    }

    public static AssessmentStatus inProgressAssessment(String progress) {
        return new AssessmentStatus(null, InstanceAssessmentStatus.IN_PROGRESS, progress);
    }

    public static AssessmentStatus completedAssessment(Instant completedDate) {
        return new AssessmentStatus(completedDate, InstanceAssessmentStatus.COMPLETE, "100% COMPLETE");
    }

    public static AssessmentStatus notStartedAssessment() {
        return new AssessmentStatus(null, InstanceAssessmentStatus.NOT_STARTED, null);
    }

    public static AssessmentStatus failedAssessment() {
        return new AssessmentStatus(null, InstanceAssessmentStatus.FAILED, null);
    }

    @Nullable
    @Generated
    public Instant getCompletedDate() {
        return this.completedDate;
    }

    @Generated
    public InstanceAssessmentStatus getStatus() {
        return this.status;
    }

    @Nullable
    @Generated
    public String getProgress() {
        return this.progress;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssessmentStatus)) {
            return false;
        }
        AssessmentStatus other = (AssessmentStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Instant this$completedDate = this.getCompletedDate();
        Instant other$completedDate = other.getCompletedDate();
        if (this$completedDate == null ? other$completedDate != null : !((Object)this$completedDate).equals(other$completedDate)) {
            return false;
        }
        InstanceAssessmentStatus this$status = this.getStatus();
        InstanceAssessmentStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$progress = this.getProgress();
        String other$progress = other.getProgress();
        return !(this$progress == null ? other$progress != null : !this$progress.equals(other$progress));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssessmentStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $completedDate = this.getCompletedDate();
        result = result * 59 + ($completedDate == null ? 43 : ((Object)$completedDate).hashCode());
        InstanceAssessmentStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssessmentStatus(completedDate=" + this.getCompletedDate() + ", status=" + (Object)((Object)this.getStatus()) + ", progress=" + this.getProgress() + ")";
    }
}

