/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.prc;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.mapi.external.model.PublicApiException;
import com.atlassian.migration.agent.rest.ContainerTokenState;
import com.atlassian.migration.agent.rest.ContainerTokenValidator;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.prc.PrcPollerExecutionService;
import com.atlassian.migration.agent.service.prc.PrcPollerMetadataCache;
import com.atlassian.migration.prc.client.PollerExecutionService;
import com.atlassian.migration.prc.client.PrcPollerManager;
import com.atlassian.migration.prc.client.model.PollerConfig;
import com.atlassian.sal.api.license.LicenseHandler;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrcClientService {
    private final PollerConfigHandler pollerConfigHandler;
    private final LicenseHandler licenseHandler;
    private final CloudSiteService cloudSiteService;
    private final ContainerTokenValidator containerTokenValidator;
    private final PrcPollerManager prcPollerManager;
    private final PrcPollerMetadataCache prcPollerMetadataCache;
    private final MigrationPlatformService migrationPlatformService;
    private static final String CONFLUENCE_FLOW = "confluence-server-to-cloud-";
    private static final Logger log = LoggerFactory.getLogger(PrcClientService.class);

    public PrcClientService(PollerConfigHandler pollerConfigHandler, LicenseHandler licenseHandler, CloudSiteService cloudSiteService, PrcPollerExecutionService prcPollerExecutionService, ContainerTokenValidator containerTokenValidator, PrcPollerMetadataCache prcPollerMetadataCache, MigrationPlatformService migrationPlatformService) {
        this.pollerConfigHandler = pollerConfigHandler;
        this.licenseHandler = licenseHandler;
        this.cloudSiteService = cloudSiteService;
        this.prcPollerManager = new PrcPollerManager((PollerExecutionService)prcPollerExecutionService);
        this.containerTokenValidator = containerTokenValidator;
        this.prcPollerMetadataCache = prcPollerMetadataCache;
        this.migrationPlatformService = migrationPlatformService;
    }

    public Instant attach(String cloudUrl) {
        CloudSite cloudSite = this.getCloudSite(cloudUrl);
        String channelName = CONFLUENCE_FLOW + this.licenseHandler.getServerId();
        PollerConfig pollerConfig = this.pollerConfigHandler.getPollerConfigWithCallbacks(channelName, cloudSite.getCloudId(), cloudSite.getContainerToken());
        log.info("Starting poller for cloudUrl : {}", (Object)cloudUrl);
        return this.processAttach(cloudSite, pollerConfig);
    }

    public Instant attachUntilTokenExpiry(String cloudUrl) {
        CloudSite cloudSite = this.getCloudSite(cloudUrl);
        int secondsUntilTokenExpiry = this.getSecondsUntilTokenExpiry(cloudSite);
        String channelName = CONFLUENCE_FLOW + this.licenseHandler.getServerId();
        PollerConfig pollerConfig = this.pollerConfigHandler.getPollerConfigWithCallbacksAndExpiry(channelName, cloudSite.getCloudId(), cloudSite.getContainerToken(), secondsUntilTokenExpiry);
        log.info("Starting poller for cloudUrl : {}. Will expire in {} seconds (when the token expires) ", (Object)cloudUrl, (Object)secondsUntilTokenExpiry);
        return this.processAttach(cloudSite, pollerConfig);
    }

    private Instant processAttach(CloudSite cloudSite, PollerConfig pollerConfig) {
        try {
            this.prcPollerMetadataCache.setPrcPollerUserContext(cloudSite.getCloudUrl(), AuthenticatedUserThreadLocal.get());
            this.prcPollerMetadataCache.removeContainerTokenInCacheForCloudId(cloudSite.getCloudId());
            this.prcPollerManager.startPollingAsync(pollerConfig);
            return Instant.ofEpochSecond(Instant.now().getEpochSecond() + (long)pollerConfig.getPollerExpiryTimeInSec());
        }
        catch (Exception ex) {
            log.error("Error starting poller for cloud url : {} with error: {}", (Object)cloudSite.getCloudUrl(), (Object)ex);
            throw ex;
        }
    }

    @NotNull
    private CloudSite getCloudSite(String cloudUrl) {
        Optional<CloudSite> cloudSiteOpt = this.cloudSiteService.getByCloudUrl(cloudUrl);
        if (!cloudSiteOpt.isPresent() || this.containerTokenValidator.validateContainerToken(cloudSiteOpt.get()) != ContainerTokenState.VALID) {
            log.error("Cloud site is either incorrect or not authorised with server for cloud url : {}", (Object)cloudUrl);
            throw new PublicApiException.CloudUrlDoesNotExist(cloudUrl);
        }
        return cloudSiteOpt.get();
    }

    private int getSecondsUntilTokenExpiry(CloudSite cloudSiteOpt) {
        Date containerTokenExpiry = this.migrationPlatformService.getContainerTokenExpiry(cloudSiteOpt.getContainerToken());
        return Math.toIntExact(Duration.between(Instant.now(), containerTokenExpiry.toInstant()).getSeconds());
    }
}

