/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.entity.InstanceAnalysisControl;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.guardrails.InstanceAnalysisControlService;
import com.atlassian.migration.agent.service.guardrails.InstanceAnalysisControlTypes;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentService;
import com.atlassian.migration.agent.service.guardrails.external.ExternalJob;
import com.atlassian.migration.agent.service.guardrails.external.ExternalJobsFactory;
import com.atlassian.migration.agent.service.guardrails.usage.AccessLogProcessingJobRunner;
import com.atlassian.migration.agent.store.guardrails.AssessmentStatus;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.guardrails.InstanceAnalysisControlStore;
import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AssessmentJobProgressService {
    private static final Logger log = ContextLoggerFactory.getLogger(AssessmentJobProgressService.class);
    private final InstanceAnalysisControlStore instanceAnalysisControlStore;
    private final InstanceAnalysisControlService instanceAnalysisControlService;
    private final MigrationDarkFeaturesManager featuresManager;
    private static final String SERVER_NODE = "serverNode";
    private static final int TIME_IN_MINUTES = 60;
    private final InstanceAssessmentService instanceAssessmentService;
    private final GuardrailsResponseGroupStore guardrailsResponseGroupStore;
    private final AccessLogProcessingJobRunner accessLogProcessingJobRunner;
    private final ExternalJobsFactory externalJobsFactory;

    public AssessmentJobProgressService(InstanceAnalysisControlStore instanceAnalysisControlStore, InstanceAnalysisControlService instanceAnalysisControlService, MigrationDarkFeaturesManager featuresManager, GuardrailsResponseGroupStore guardrailsResponseGroupStore, InstanceAssessmentService instanceAssessmentService, AccessLogProcessingJobRunner accessLogProcessingJobRunner, ExternalJobsFactory externalJobsFactory) {
        this.instanceAnalysisControlStore = instanceAnalysisControlStore;
        this.instanceAnalysisControlService = instanceAnalysisControlService;
        this.featuresManager = featuresManager;
        this.instanceAssessmentService = instanceAssessmentService;
        this.guardrailsResponseGroupStore = guardrailsResponseGroupStore;
        this.accessLogProcessingJobRunner = accessLogProcessingJobRunner;
        this.externalJobsFactory = externalJobsFactory;
    }

    public AssessmentStatus processJobProgress() {
        AssessmentStatus assessmentStatus = this.getAssessmentStatus();
        if (assessmentStatus.getStatus() == InstanceAssessmentStatus.IN_PROGRESS) {
            return assessmentStatus;
        }
        List<ExternalJob> externalJobs = this.externalJobsFactory.getExternalJobs();
        Optional<ExternalJob> externalJobInProgress = this.filter(externalJobs, ExternalJob.ExternalJobStatus.IN_PROGRESS).findFirst();
        if (externalJobInProgress.isPresent()) {
            return AssessmentStatus.inProgressAssessment(externalJobInProgress.get().name());
        }
        if (assessmentStatus.getStatus() == InstanceAssessmentStatus.COMPLETE && !externalJobs.isEmpty()) {
            if (this.filter(externalJobs, ExternalJob.ExternalJobStatus.ERROR).findAny().isPresent()) {
                return AssessmentStatus.failedAssessment();
            }
            Instant completedTimestamp = Stream.concat(this.filter(externalJobs, ExternalJob.ExternalJobStatus.COMPLETED).map(ExternalJob::getCompletedTimestamp), Stream.of(assessmentStatus.getCompletedDate())).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null);
            return AssessmentStatus.completedAssessment(completedTimestamp);
        }
        return assessmentStatus;
    }

    private Stream<ExternalJob> filter(List<ExternalJob> jobs, ExternalJob.ExternalJobStatus status) {
        return jobs.stream().filter(job -> job.getStatus() == status);
    }

    @NotNull
    private AssessmentStatus getAssessmentStatus() {
        Optional<InstanceAnalysisControl> instanceAnalysisControl;
        if (this.featuresManager.isBrowserMetricsEnabled() && (instanceAnalysisControl = this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name())).isPresent()) {
            return this.getCompleteAnalysisProgress(instanceAnalysisControl.get());
        }
        Optional<GuardrailsResponseGroup> guardrailsResponseGroup = this.guardrailsResponseGroupStore.findLastJobId();
        if (!guardrailsResponseGroup.isPresent()) {
            return AssessmentStatus.notStartedAssessment();
        }
        String jobId = guardrailsResponseGroup.get().getJobId();
        try {
            Set<JobDetails> activeJobsDetails = this.instanceAssessmentService.getActiveJobs();
            Set activeJobs = activeJobsDetails.stream().map(JobDetails::getJobId).map(Object::toString).collect(Collectors.toSet());
            log.info("Current jobId is:{} and number of running jobs are :{}", (Object)jobId, (Object)activeJobs.size());
            if (activeJobs.contains(jobId)) {
                long progress = this.instanceAssessmentService.getJobProgress(jobId);
                return AssessmentStatus.inProgressAssessment(progress + "% COMPLETE");
            }
            log.info("Job completed for jobId:{}", (Object)jobId);
            return AssessmentStatus.completedAssessment(Instant.ofEpochMilli(guardrailsResponseGroup.get().getEndTimestamp()));
        }
        catch (Exception e) {
            log.error("Failed to get progress for jobId:{} with exception:{}", (Object)jobId, (Object)e);
            return AssessmentStatus.failedAssessment();
        }
    }

    private AssessmentStatus getCompleteAnalysisProgress(InstanceAnalysisControl instanceAnalysisControl) {
        if (this.instanceAnalysisControlStore.isFinished(instanceAnalysisControl.getEndTimestamp())) {
            if (!this.accessLogProcessingJobRunner.isFinished()) {
                return AssessmentStatus.inProgressAssessment("0 h 1 m remaining");
            }
            Long endTimestamp = instanceAnalysisControl.getEndTimestamp();
            Timestamp tms = new Timestamp(endTimestamp);
            Date completedDate = new Date(tms.getTime());
            return AssessmentStatus.completedAssessment(completedDate.toInstant());
        }
        Duration remainingDuration = this.instanceAnalysisControlService.calculateRemainingDuration(instanceAnalysisControl);
        if (remainingDuration.isZero()) {
            this.stopAssessmentCollection();
        }
        return AssessmentStatus.inProgressAssessment(remainingDuration.toHours() + " h " + remainingDuration.toMinutes() % 60L + " m remaining");
    }

    private void stopAssessmentCollection() {
        log.info("Stopping Assessment Collection.");
        if (this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name()).isPresent()) {
            this.instanceAnalysisControlService.finishAssessmentCollection();
            this.accessLogProcessingJobRunner.cleanup();
        }
    }

    public AssessmentStatus scheduleInstanceAssessment() throws SchedulerServiceException {
        Set<JobDetails> activeJobs;
        Optional<InstanceAnalysisControl> currentInstanceAnalysis;
        if (this.featuresManager.isBrowserMetricsEnabled()) {
            this.accessLogProcessingJobRunner.startAssessment();
        }
        if ((currentInstanceAnalysis = this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name())).isPresent() && !this.instanceAnalysisControlStore.isFinished(currentInstanceAnalysis.get().getEndTimestamp())) {
            return AssessmentStatus.inProgressAssessment(this.processJobProgress().getProgress());
        }
        if (this.featuresManager.isBrowserMetricsEnabled()) {
            this.instanceAnalysisControlService.startAssessmentCollection();
        }
        if (!(activeJobs = this.instanceAssessmentService.getActiveJobs()).isEmpty()) {
            JobDetails job = activeJobs.iterator().next();
            String jobId = job.getJobId().toString();
            Map map = job.getParameters();
            String nodeId = (String)map.get(SERVER_NODE);
            log.info("Job already running for nodeId: {} and jobId:{}", (Object)nodeId, (Object)jobId);
            return AssessmentStatus.inProgressAssessment(this.processJobProgress().getProgress());
        }
        log.info("There are no active jobs");
        this.instanceAssessmentService.scheduleJob();
        this.externalJobsFactory.getExternalJobs().forEach(externalJob -> {
            externalJob.start();
            log.info("Scheduled external job: {}", (Object)externalJob.name());
        });
        return AssessmentStatus.newAssessment();
    }
}

