/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.network;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.network.ConnectivityTester;
import com.atlassian.migration.agent.service.check.network.NetworkHealthCheckContextProvider;
import com.atlassian.migration.agent.service.check.network.NetworkHealthChecker;
import com.atlassian.migration.agent.service.check.network.NetworkHealthContext;
import com.atlassian.migration.agent.service.check.network.NetworkHealthMapper;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class NetworkHealthCheckRegistration
implements CheckRegistration<NetworkHealthContext> {
    private final NetworkHealthChecker checker;
    private final NetworkHealthCheckContextProvider contextProvider;
    private final NetworkHealthMapper resultMapper;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;

    public NetworkHealthCheckRegistration(PlatformService platformService, PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder, ConnectivityTester connectivityTester, AnalyticsEventService analyticsEventService, MigrationAgentConfiguration migrationAgentConfiguration) {
        this.checker = new NetworkHealthChecker(platformService, connectivityTester, analyticsEventService, preflightChecksAnalyticsEventBuilder, migrationAgentConfiguration);
        this.contextProvider = new NetworkHealthCheckContextProvider();
        this.resultMapper = new NetworkHealthMapper();
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.NETWORK_HEALTH;
    }

    @Override
    public Checker<NetworkHealthContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckContextProvider<NetworkHealthContext> getCheckContextProvider() {
        return this.contextProvider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.resultMapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(CheckResult checkResult, long totalTime) {
        return this.preflightChecksAnalyticsEventBuilder.buildPreflightNetworkHealth(checkResult.success, NetworkHealthChecker.retrieveFailedNetworkHealthUrls(checkResult.details), totalTime);
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "networkHealthCheck";
    }
}

