/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.service.SpaceAttachmentCount;
import com.atlassian.migration.agent.service.UploadState;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.analytics.builders.StepLevelAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.VisibleForTesting;

public class AttachmentUploadAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;
    private final StepLevelAnalyticsEventBuilder stepLevelAnalyticsEventBuilder;

    public AttachmentUploadAnalyticsEventBuilder(SENSupplier senSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil, StepLevelAnalyticsEventBuilder stepLevelAnalyticsEventBuilder) {
        this(senSupplier, Instant::now, analyticsEventBuilderUtil, stepLevelAnalyticsEventBuilder);
    }

    @VisibleForTesting
    AttachmentUploadAnalyticsEventBuilder(SENSupplier senSupplier, Supplier<Instant> instantSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil, StepLevelAnalyticsEventBuilder stepLevelAnalyticsEventBuilder) {
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
        this.stepLevelAnalyticsEventBuilder = stepLevelAnalyticsEventBuilder;
    }

    public EventDto buildAttachmentMigrationEvent(long totalTime, SpaceAttachmentCount spaceAttachmentCount, UploadState uploadState) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"spaceKey", (Object)spaceAttachmentCount.spaceKey);
        attributes.put((Object)"cloudId", (Object)spaceAttachmentCount.cloudId);
        attributes.put((Object)"contentAttachmentCount", (Object)spaceAttachmentCount.contentAttachmentCount);
        attributes.put((Object)"migAttachmentCount", (Object)spaceAttachmentCount.retrievedMigAttachmentCount);
        attributes.put((Object)"unRetrievableMigAttachmentCount", (Object)spaceAttachmentCount.unRetrievableMigAttachmentCount);
        attributes.put((Object)"allAttachmentsMigrated", (Object)spaceAttachmentCount.hasAllAttachmentsMigrated());
        attributes.put((Object)"numOfAttachments", (Object)uploadState.numOfAttachments);
        attributes.put((Object)"numOfUploadedAttachments", (Object)uploadState.numOfUploadedAttachments);
        attributes.put((Object)"numOfFailedAttachments", (Object)uploadState.numOfFailedAttachments);
        attributes.put((Object)"uploadedBytes", (Object)uploadState.uploadedBytes);
        attributes.put((Object)"totalBytes", (Object)uploadState.totalBytes);
        attributes.put((Object)"numOfAttachmentsAlreadyMigrated", (Object)uploadState.numOfAttachmentsAlreadyMigrated);
        attributes.put((Object)"timeTaken", (Object)totalTime);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("migrated")).sen(this.senSupplier.get())).actionSubject("attachmentMigration")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildAttachmentStepTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step) {
        return this.stepLevelAnalyticsEventBuilder.buildSpaceStepTimerEvent(stepSuccessful, totalTime, "attachmentsUploaded", spaceKey, step);
    }

    public EventDto buildAttachmentMigrationStartEvent(Step step, long startTime, int batchSize, long totalCountOfAttachments, long totalSizeOfAttachments) {
        GenericOperationalEvent.Builder stepBuilder = this.analyticsEventBuilderUtil.getBuilderStartedEvent(step, startTime);
        stepBuilder.addAttribute("batchSize", (Object)batchSize);
        stepBuilder.addAttribute("totalCountOfAttachments", (Object)totalCountOfAttachments);
        stepBuilder.addAttribute("totalSizeOfAttachments", (Object)totalSizeOfAttachments);
        return stepBuilder.build();
    }
}

