/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.guardrails.results.ListResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.apache.commons.lang3.ObjectUtils;

public class TotalPagesPerSpaceQuery
extends AbstractQuery<ListResult> {
    private static final int LIMIT = 100;
    public static final String SPACE_KEY = "space_key";
    public static final String SPACE_ID = "space_id";
    public static final String TOTAL_PAGE_COUNT = "total_page_count";
    public static final String PAGE_COUNT = "page_count";
    public static final String STATUS = "status";

    public TotalPagesPerSpaceQuery(EntityManagerTemplate tmpl) {
        super(QueryIds.TOTAL_PAGES_PER_SPACE, tmpl, "select c.spaceId as space_id, s.key as space_key, count(*) as page_count, c.status as status from Content c inner join Space s on c.spaceId = s.id where c.type in ('PAGE', 'BLOGPOST') and c.previousVersion is null group by c.spaceId, s.key, c.status");
    }

    @Override
    public ListResult execute() {
        HashMap<Long, Map> bySpaceId = new HashMap<Long, Map>();
        for (Tuple tuple2 : this.listTuples()) {
            this.merge(tuple2, bySpaceId.computeIfAbsent((Long)tuple2.get(SPACE_ID, Long.class), k -> new LinkedHashMap()));
        }
        return new ListResult(bySpaceId.values().stream().sorted(Comparator.comparing(tuple -> -((Long)tuple.get(TOTAL_PAGE_COUNT)).longValue())).limit(100L).map(this::getTuple).collect(Collectors.toList()));
    }

    private Tuple getTuple(Map<String, Object> map) {
        for (String key : ImmutableList.of((Object)TOTAL_PAGE_COUNT, (Object)SPACE_ID, (Object)SPACE_KEY)) {
            map.put(key, map.remove(key));
        }
        return GuardrailsUtil.getTuple(map);
    }

    private void merge(Tuple src, Map<String, Object> dest) {
        Long pageCount = (Long)src.get(PAGE_COUNT);
        String status = (String)src.get(STATUS);
        if (pageCount != null && status != null) {
            dest.putIfAbsent(status, pageCount);
        }
        dest.merge(TOTAL_PAGE_COUNT, ObjectUtils.firstNonNull((Object[])new Long[]{pageCount, 0L}), (a, b) -> (Long)a + (Long)b);
        dest.putIfAbsent(SPACE_ID, src.get(SPACE_ID));
        dest.putIfAbsent(SPACE_KEY, src.get(SPACE_KEY));
    }
}

