/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.util.SerializationUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import lombok.Generated;

public class MacroAssessmentStore {
    private static final int MAX_DOWNLOAD_DAYS = 7;
    private static final String ASSESSMENT_FILE_NAME = "macro-assessment-store-%s.jsonl";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final BootstrapManager bootstrapManager;

    public void store(MacroAssessmentResult assessment, LocalDate date) throws IOException {
        Path jsonPathFile = this.getMacroAssessmentPath(date);
        SerializationUtil.saveJson(jsonPathFile.toFile(), assessment);
    }

    public Path getMacroAssessment(String filePrefix, LocalDate today, String serverId, String assessmentStartingDate) throws IOException {
        File macroAssessmentStoreFile = this.getExistingMacroAssessmentPath(today);
        if (macroAssessmentStoreFile == null) {
            return null;
        }
        MacroAssessmentResult result = SerializationUtil.deserializeJson(macroAssessmentStoreFile, MacroAssessmentResult.class);
        result.addIdentification(serverId, assessmentStartingDate);
        Path newPath = Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), filePrefix + DATE_FORMATTER.format(today) + ".jsonl");
        SerializationUtil.saveJson(newPath.toFile(), result);
        return newPath;
    }

    private File getExistingMacroAssessmentPath(LocalDate today) {
        for (int i = 0; i <= 7; ++i) {
            File file = this.getMacroAssessmentPath(today.minusDays(i)).toFile();
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private Path getMacroAssessmentPath(LocalDate date) {
        String assessmentFileName = String.format(ASSESSMENT_FILE_NAME, DATE_FORMATTER.format(date));
        return Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), assessmentFileName);
    }

    @Generated
    public MacroAssessmentStore(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }
}

