/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.entity.GuardrailsResponse;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.guardrails.BrowserMetricsService;
import com.atlassian.migration.agent.service.guardrails.GuardrailsCsvOutputStreamResult;
import com.atlassian.migration.agent.service.guardrails.InstanceMetadataCollector;
import com.atlassian.migration.agent.service.guardrails.external.ExternalJobsFactory;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentStore;
import com.atlassian.migration.agent.service.guardrails.usage.DailyUsageMetricsStore;
import com.atlassian.migration.agent.service.guardrails.util.CsvBuilder;
import com.atlassian.migration.agent.service.guardrails.util.ZipBuilder;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

public class InstanceAssessmentCSVService {
    private static final Logger log = ContextLoggerFactory.getLogger(InstanceAssessmentCSVService.class);
    private final BootstrapManager bootstrapManager;
    private final GuardrailsResponseStore guardrailsResponseStore;
    private final DailyUsageMetricsStore dailyUsageMetricsStore;
    private final InstanceMetadataCollector instanceMetadataCollector;
    private final BrowserMetricsService browserMetricsService;
    private final GuardrailsResponseGroupStore guardrailsResponseGroupStore;
    private final MacroAssessmentStore macroAssessmentStore;
    private final PluginTransactionTemplate ptx;
    private final ExternalJobsFactory externalJobsFactory;

    public InstanceAssessmentCSVService(BootstrapManager bootstrapManager, GuardrailsResponseStore guardrailsResponseStore, InstanceMetadataCollector instanceMetadataCollector, BrowserMetricsService browserMetricsService, GuardrailsResponseGroupStore guardrailsResponseGroupStore, PluginTransactionTemplate ptx, DailyUsageMetricsStore dailyUsageMetricsStore, MacroAssessmentStore macroAssessmentStore, ExternalJobsFactory externalJobsFactory) {
        this.ptx = ptx;
        this.bootstrapManager = bootstrapManager;
        this.macroAssessmentStore = macroAssessmentStore;
        this.browserMetricsService = browserMetricsService;
        this.dailyUsageMetricsStore = dailyUsageMetricsStore;
        this.guardrailsResponseStore = guardrailsResponseStore;
        this.instanceMetadataCollector = instanceMetadataCollector;
        this.guardrailsResponseGroupStore = guardrailsResponseGroupStore;
        this.externalJobsFactory = externalJobsFactory;
    }

    Path createBrowserMetricsJsonFile(String date, InstanceMetadataDto instanceMetadataDto) throws IOException {
        return this.browserMetricsService.exportBrowserMetrics("confluence-browser-metrics-" + date, instanceMetadataDto);
    }

    Path createUsageMetrics(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto) throws IOException {
        return this.dailyUsageMetricsStore.createDailyUsageMetricsCsv(this.csvFilePath("confluence-usage-metrics-" + date), today, instanceMetadataDto);
    }

    Path createPageTrafficDistributionMetrics(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto) throws IOException {
        return this.dailyUsageMetricsStore.createPageTrafficDistributionCsv(this.csvFilePath("confluence-traffic-distribution-" + date), today, instanceMetadataDto);
    }

    Path createMacroAssessmentJsonFile(LocalDate today, String serverId, String assessmentStartingDate) throws IOException {
        return this.macroAssessmentStore.getMacroAssessment("confluence-macros-", today, serverId, assessmentStartingDate);
    }

    public GuardrailsCsvOutputStreamResult generate(LocalDate today, String date, OutputStream outputStream) {
        Optional<GuardrailsResponseGroup> guardrailsResponseGroup = this.guardrailsResponseGroupStore.findLastJobId();
        if (!guardrailsResponseGroup.isPresent()) {
            return GuardrailsCsvOutputStreamResult.failed(outputStream, false, new RuntimeException("Unable to generate file for download: ${e.message}"));
        }
        try {
            String jobId = guardrailsResponseGroup.get().getJobId();
            List guardrailsResponses = this.ptx.read(() -> this.guardrailsResponseStore.getResponses(jobId));
            if (guardrailsResponses.isEmpty()) {
                log.error("No records found");
                return GuardrailsCsvOutputStreamResult.failed(outputStream, true, new RuntimeException("No records found"));
            }
            ZipBuilder zipBuilder = new ZipBuilder(outputStream);
            InstanceMetadataDto instanceMetadataDto = this.instanceMetadataCollector.collectMetadata(jobId);
            zipBuilder.add(this.createGuardrailsCsv(guardrailsResponses, instanceMetadataDto, this.csvFilePath("confluence-entities-" + date)));
            zipBuilder.maybeAdd(this.createBrowserMetricsJsonFile(date, instanceMetadataDto));
            zipBuilder.maybeAdd(this.createUsageMetrics(today, date, instanceMetadataDto));
            zipBuilder.maybeAdd(this.createPageTrafficDistributionMetrics(today, date, instanceMetadataDto));
            zipBuilder.maybeAdd(this.createMacroAssessmentJsonFile(today, instanceMetadataDto.getServerId(), instanceMetadataDto.getAssessmentDate()));
            this.externalJobsFactory.getExternalJobs().forEach(externalJob -> zipBuilder.maybeAdd(externalJob.getOutputFiles(date), externalJob.name()));
            zipBuilder.create(true);
            return GuardrailsCsvOutputStreamResult.succeeded(outputStream);
        }
        catch (Exception e) {
            guardrailsResponseGroup.ifPresent(responseGroup -> log.error("Unable to generate file for download: {} - {} - {}", new Object[]{responseGroup.getJobId(), e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)}));
            return GuardrailsCsvOutputStreamResult.failed(outputStream, false, new RuntimeException("Unable to generate file for download: " + e.getMessage(), e));
        }
    }

    public Path createGuardrailsCsv(List<GuardrailsResponse> responses, InstanceMetadataDto instanceMetadataDto, Path csv) throws IOException {
        return new CsvBuilder<GuardrailsResponse>().addColumn("query_item", GuardrailsResponse::getQueryId).addColumn("query_result", GuardrailsResponse::getQueryResponse).addColumn("query_status", GuardrailsResponse::getQueryStatus).addColumn("product_name", instanceMetadataDto.getProduct().getName()).addColumn("product_version", instanceMetadataDto.getProduct().getVersion()).addColumn("sen", instanceMetadataDto.getSen()).addColumn("server_id", instanceMetadataDto.getServerId()).addColumn("instance_timezone", instanceMetadataDto.getInstanceTimezone()).addColumn("assessment_starting_date", instanceMetadataDto.getAssessmentDate()).build(csv, responses);
    }

    private Path csvFilePath(String name) {
        return this.getPath().resolve(name + ".csv");
    }

    private Path getPath() {
        return Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), "guardrails");
    }
}

