/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericScreenEvent;
import com.atlassian.cmpt.analytics.events.GenericTrackEvent;
import com.atlassian.cmpt.analytics.events.GenericUiEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.analytics.ScreenAnalyticsEventDto;
import com.atlassian.migration.agent.dto.analytics.TrackAnalyticsEventDto;
import com.atlassian.migration.agent.dto.analytics.UIAnalyticsEventDto;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class UIAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final PluginVersionManager pluginVersionManager;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public UIAnalyticsEventBuilder(SENSupplier senSupplier, PluginVersionManager pluginVersionManager, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.senSupplier = senSupplier;
        this.pluginVersionManager = pluginVersionManager;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    public EventDto buildUIAnalyticsEvent(UIAnalyticsEventDto eventDto, ConfluenceUser confluenceUser) {
        return ((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)new GenericUiEvent.Builder(eventDto.getTimestamp()).email(confluenceUser == null ? null : confluenceUser.getEmail())).sen(this.senSupplier.get())).source(eventDto.getSource())).contextContainer(eventDto.getContainerType(), eventDto.getContainerId())).actionSubject(eventDto.getActionSubject(), eventDto.getActionSubjectId())).action(eventDto.getAction())).withAttributes(this.analyticsEventBuilderUtil.addCommonFrontendAttributes(eventDto.getAttributes()))).build();
    }

    public EventDto buildScreenAnalyticsEvent(ScreenAnalyticsEventDto eventDto, ConfluenceUser confluenceUser) {
        return ((GenericScreenEvent.Builder)((GenericScreenEvent.Builder)((GenericScreenEvent.Builder)((GenericScreenEvent.Builder)new GenericScreenEvent.Builder(eventDto.getTimestamp()).name(eventDto.getName())).sen(this.senSupplier.get())).email(confluenceUser == null ? null : confluenceUser.getEmail())).withAttributes(this.analyticsEventBuilderUtil.addCommonFrontendAttributes(eventDto.getAttributes()))).build();
    }

    public EventDto buildTrackAnalyticsEvent(TrackAnalyticsEventDto eventDto, PlanDto planDto, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        String action = eventDto.getAction();
        if ("stopped".equals(action)) {
            attributes.put((Object)"status", (Object)planDto.getProgress().getStatus());
            attributes.put((Object)"stopTime", (Object)planDto.getProgress().getEndTime());
        }
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(eventDto.getTimestamp()).action(eventDto.getAction())).sen(this.senSupplier.get())).email(confluenceUser == null ? null : confluenceUser.getEmail())).source(eventDto.getSource())).actionSubject(eventDto.getActionSubject(), eventDto.getActionSubjectId())).withAttributes((Map)attributes.build())).build();
    }
}

