/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.migration.agent.service.SpaceConflict;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.network.NetworkCheckResult;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.app.dto.check.CheckDetail;
import com.atlassian.migration.app.dto.check.CheckStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class PreflightChecksAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final PluginVersionManager pluginVersionManager;

    public PreflightChecksAnalyticsEventBuilder(SENSupplier senSupplier, PluginVersionManager pluginVersionManager) {
        this(senSupplier, Instant::now, pluginVersionManager);
    }

    @VisibleForTesting
    PreflightChecksAnalyticsEventBuilder(SENSupplier senSupplier, Supplier<Instant> instantSupplier, PluginVersionManager pluginVersionManager) {
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.pluginVersionManager = pluginVersionManager;
    }

    private ImmutableMap.Builder<String, Object> getBuilderWithCommonAttributes() {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"productFamily", (Object)"confluence");
        attributes.put((Object)"migrationType", (Object)"S2C_MIGRATION");
        return attributes;
    }

    private void addCommonAttributesInPreflightCheck(boolean success, long totalTime, ImmutableMap.Builder<String, Object> attributes) {
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"totalTime", (Object)String.format(Locale.US, "%.1f", (double)totalTime / 1000.0));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
    }

    public EventDto buildPreflightDuplicateEmails(boolean success, List<EmailDuplicate> duplicateEmails, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        LongAdder numberOfEmails = new LongAdder();
        LongAdder numberOfUsers = new LongAdder();
        duplicateEmails.forEach(duplicateEmail -> {
            numberOfEmails.increment();
            numberOfUsers.add(duplicateEmail.ids.size());
        });
        attributes.put((Object)"numberOfSharedEmails", (Object)Long.toString(numberOfEmails.longValue()));
        attributes.put((Object)"numberOfUsers", (Object)Long.toString(numberOfUsers.longValue()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("sharedEmailsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightInvalidEmails(boolean success, List<EmailData> invalidEmails, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfInvalidEmails", (Object)Long.toString(invalidEmails.size()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("invalidEmailsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightGroupNamesConflict(boolean success, List<String> groups, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfGroups", (Object)Long.toString(groups.size()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("cloudExistantGroupsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightSpaceKeysConflict(boolean success, List<SpaceConflict> conflicts, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfSpaces", (Object)Long.toString(conflicts.size()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("spaceConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightGlobalDataTemplatesConflict(boolean success, int numOfConflicts, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfTemplates", (Object)Integer.toString(numOfConflicts));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("globalDataTemplateConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppOutdated(boolean success, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("migrationAssistantOutdatedCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightConfluenceSupportedVersionCheck(boolean success, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject(CheckType.CONFLUENCE_SUPPORTED_VERSION.value())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightCloudFreeUsersCheck(boolean success, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("cloudFreeUsersConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightCloudPremiumEditionCheck(boolean success, long totalTime, String edition) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        if (edition != null) {
            attributes.put((Object)"edition", (Object)edition);
        }
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("cloudPremiumEditionCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightSpaceAnonymousAccess(boolean success, Integer numberOfSpaces, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfSpaces", (Object)Integer.toString(numberOfSpaces));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("spaceAnonymousPermissionCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightTcAppVersion(boolean success, long totalTime, String appVersion) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        if (appVersion != null) {
            attributes.put((Object)"tcAppVersion", (Object)appVersion);
        }
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("teamCalendarsVersionCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreFlightContainerTokenExpiration(boolean success, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("containerTokenExpirationCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreFlightMigrationOrchestratorMaintenance(boolean success, long totalTime) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        this.addCommonAttributesInPreflightCheck(success, totalTime, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("migrationOrchestratorMaintenanceCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppAssessmentComplete(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appAssessmentCompleteCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightAppDataConsent(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appDataMigrationConsentCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightAppReliability(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appReliabilityCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightServerAppOutdated(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("serverAppOutdatedCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightAppsNotInstalledOnCloud(boolean success, int apps, long totalTime) {
        return this.buildPreflightAppsDefault("appsNotInstalledOnCloudCheck", success, apps, totalTime);
    }

    public EventDto buildPreflightAppLicenseCheck(boolean success, Set<String> appsSucceeded, Set<String> appsFailed, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        int numberOfAppsChecked = appsSucceeded.size() + appsFailed.size();
        attributes.put((Object)"numberOfApps", (Object)Integer.toString(numberOfAppsChecked));
        attributes.put((Object)"numberOfAppsChecked", (Object)Integer.toString(numberOfAppsChecked));
        attributes.put((Object)"numberOfAppsFailed", (Object)Integer.toString(appsFailed.size()));
        attributes.put((Object)"appsWithSuccessfulCheck", appsSucceeded);
        attributes.put((Object)"appsWithFailedCheck", appsFailed);
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("appLicenseCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppsDefault(String subject, boolean success, int apps, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfApps", (Object)Integer.toString(apps));
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject(subject)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppVendorCheck(CheckResult checkResult, long totalTime) {
        if (Checker.retrieveExecutionErrorCode((CheckResult)checkResult) != null) {
            ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
            attributes.put((Object)"atlassianException", (Object)true);
            this.addCommonAttributesInPreflightCheck(checkResult.success, totalTime, attributes);
            return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("appVendorCheck")).withAttributes((Map)attributes.build())).build();
        }
        Map appVendorCheckResult = checkResult.details;
        int totalNumberOfApps = appVendorCheckResult.size();
        Set resultDtos = appVendorCheckResult.values().stream().flatMap(checkIdToCheckResultMap -> ((HashMap)checkIdToCheckResultMap).values().stream()).collect(Collectors.toSet());
        int totalChecksExecuted = resultDtos.size();
        int totalFailedChecks = (int)resultDtos.stream().filter(checkResultDto -> checkResultDto.status != CheckStatus.SUCCESS).count();
        List checksWithStatusWarning = resultDtos.stream().filter(checkResultDto -> checkResultDto.status == CheckStatus.WARNING).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithStatusBlocked = resultDtos.stream().filter(checkResultDto -> checkResultDto.status == CheckStatus.BLOCKING).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithStatusCheckExecutionError = resultDtos.stream().filter(checkResultDto -> checkResultDto.status == CheckStatus.CHECK_EXECUTION_ERROR).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List unsuccessfulChecksWithCsvContent = resultDtos.stream().filter(checkResultDto -> checkResultDto.showCsv).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithException = resultDtos.stream().filter(checkResultDto -> checkResultDto.getCheckDetails() != null && checkResultDto.getCheckDetails().contains(CheckDetail.EXCEPTION)).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithTimeout = resultDtos.stream().filter(checkResultDto -> checkResultDto.getCheckDetails() != null && checkResultDto.getCheckDetails().contains(CheckDetail.TIMEOUT)).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithCsvTruncation = resultDtos.stream().filter(checkResultDto -> checkResultDto.getCheckDetails() != null && checkResultDto.getCheckDetails().contains(CheckDetail.CSV_TRUNCATED)).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfApps", (Object)Integer.toString(totalNumberOfApps));
        attributes.put((Object)"numberOfChecksExecuted", (Object)Integer.toString(totalChecksExecuted));
        attributes.put((Object)"numberOfFailedChecks", (Object)Integer.toString(totalFailedChecks));
        attributes.put((Object)"unsuccessfulChecksAsWarning", checksWithStatusWarning);
        attributes.put((Object)"unsuccessfulChecksAsBlocking", checksWithStatusBlocked);
        attributes.put((Object)"unsuccessfulChecksAsCheckExecutionError", checksWithStatusCheckExecutionError);
        attributes.put((Object)"unsuccessfulChecksWithCSVContent", unsuccessfulChecksWithCsvContent);
        attributes.put((Object)"checksWithException", checksWithException);
        attributes.put((Object)"checksWithTimeout", checksWithTimeout);
        attributes.put((Object)"checksWithCsvTruncation", checksWithCsvTruncation);
        this.addCommonAttributesInPreflightCheck(checkResult.success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("appVendorCheck")).withAttributes((Map)attributes.build())).build();
    }

    public List<EventDto> buildPreflightAppVendorCheckIndividual(Map<String, Object> appVendorCheckResult, boolean devModeFFEnabled, @Nullable String planId, @Nullable String planMigrationTag, long totalTime) {
        return appVendorCheckResult.keySet().stream().flatMap(appKey -> {
            Map checkIdToCheckResultMap = (Map)appVendorCheckResult.get(appKey);
            return checkIdToCheckResultMap.values().stream().map(checkResultDto -> {
                boolean executed = checkResultDto.status != CheckStatus.CHECK_EXECUTION_ERROR;
                boolean success = checkResultDto.status == CheckStatus.SUCCESS;
                boolean csvContentTruncated = false;
                boolean exception = false;
                boolean timeout = false;
                if (checkResultDto.getCheckDetails() != null) {
                    csvContentTruncated = checkResultDto.getCheckDetails().contains(CheckDetail.CSV_TRUNCATED);
                    exception = checkResultDto.getCheckDetails().contains(CheckDetail.EXCEPTION);
                    timeout = checkResultDto.getCheckDetails().contains(CheckDetail.TIMEOUT);
                }
                ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
                this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
                attributes.put((Object)"appKey", appKey);
                attributes.put((Object)"csvContentTruncated", (Object)csvContentTruncated);
                attributes.put((Object)"devModeFFEnabled", (Object)devModeFFEnabled);
                attributes.put((Object)"csvContent", (Object)checkResultDto.showCsv);
                attributes.put((Object)"exception", (Object)exception);
                attributes.put((Object)"executed", (Object)executed);
                attributes.put((Object)"timeout", (Object)timeout);
                if (checkResultDto.checkId != null) {
                    attributes.put((Object)"checkId", (Object)checkResultDto.checkId);
                }
                if (planId != null) {
                    attributes.put((Object)"planId", (Object)planId);
                }
                if (planMigrationTag != null) {
                    attributes.put((Object)"migrationTag", (Object)planMigrationTag);
                }
                if (checkResultDto.status != null) {
                    attributes.put((Object)"status", (Object)checkResultDto.status);
                }
                return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).actionSubject("appVendorCheckIndividual")).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).withAttributes((Map)attributes.build())).build();
            });
        }).collect(Collectors.toList());
    }

    public EventDto buildPreflightAppWebhookEndpointCheck(CheckResult checkResult, long totalTime, Set<String> appsList, String cloudId) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        Set appWebhookCheckResult = checkResult.details.getOrDefault("appKeysMissingWebhooks", Collections.emptySet());
        Set appsWithFailedCheck = appWebhookCheckResult.stream().map(it -> it.key).collect(Collectors.toSet());
        attributes.put((Object)"numberOfApps", (Object)Integer.toString(appsList.size()));
        attributes.put((Object)"numberOfAppsChecked", (Object)Integer.toString(appsList.size()));
        attributes.put((Object)"numberOfAppsFailed", (Object)Integer.toString(appsWithFailedCheck.size()));
        attributes.put((Object)"appsWithSuccessfulCheck", (Object)CollectionUtils.subtract(appsList, appsWithFailedCheck));
        attributes.put((Object)"appsWithFailedCheck", appsWithFailedCheck);
        attributes.put((Object)"cloudId", (Object)cloudId);
        this.addCommonAttributesInPreflightCheck(checkResult.success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("appWebhookEndpointCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightFailed(String actionSubject, String executionId, int executionErrorCode) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"executionErrorCode", (Object)executionErrorCode);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("failed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject(actionSubject)).contextContainer("preflightCheck", executionId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightMissingAttachments(boolean success, int size, long totalTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfMissingAttachments", (Object)size);
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("missingAttachmentsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightTrustedDomain(boolean success, long totalTime) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        this.addCommonAttributesInPreflightCheck(success, totalTime, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("trustedDomainCheck")).withAttributes((Map)attributes.build())).build();
    }

    @NotNull
    private GenericOperationalEvent buildPreflightNetworkHealthEvent(boolean success, List<NetworkCheckResult> networkCheckResults, long totalTime, String action, String actionSubject) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfFailedDomains", (Object)Long.toString(networkCheckResults.size()));
        Map<String, List> failedUrlsByServiceNameMap = networkCheckResults.stream().collect(Collectors.toMap(NetworkCheckResult::getName, NetworkCheckResult::getFailedDomains));
        attributes.put((Object)"failedDomainsByServiceName", failedUrlsByServiceNameMap);
        this.addCommonAttributesInPreflightCheck(success, totalTime, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).source("checkScreen")).actionSubject(actionSubject)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightNetworkHealth(boolean success, List<NetworkCheckResult> networkCheckResults, long totalTime) {
        return this.buildPreflightNetworkHealthEvent(success, networkCheckResults, totalTime, "executed", "networkHealthCheck");
    }

    public EventDto buildPreMigrationPreflightNetworkHealth(boolean success, List<NetworkCheckResult> networkCheckResults, long totalTime) {
        String action = success ? "executed" : "failed";
        return this.buildPreflightNetworkHealthEvent(success, networkCheckResults, totalTime, action, "networkHealthPreMigrationCheck");
    }
}

