/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.guardrails.results.ListResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;

public class SizeOfNonPersonalSpacesQuery
extends AbstractQuery<ListResult> {
    private static final int LIMIT = 10;

    public SizeOfNonPersonalSpacesQuery(EntityManagerTemplate tmpl) {
        super(QueryIds.SIZE_OF_NON_PERSONAL_SPACES, tmpl, "select cast(sum(cp.longval)/1024/1024/1024 as big_decimal) as space_size, max(s.id) as space_id, s.type as space_type, s.status as space_status from Space as s inner join Content as c on s.id = c.space.id left outer join ContentProperty as cp on c.id = cp.content where s.type = 'global' and s.status = 'CURRENT' and s.key is not null and s.name is not null and s.type is not null and s.status is not null group by s.key, s.name, s.type, s.status order by space_size desc");
    }

    @Override
    public ListResult execute() {
        List<Tuple> result = this.prepareQuery(Tuple.class).stream().filter(t -> t.get(0) != null).limit(10L).collect(Collectors.toList());
        return new ListResult(result);
    }
}

