/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.guardrails.results.TupleResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import javax.persistence.Tuple;

public class MaxSizePersonalSpaceQuery
extends AbstractQuery<TupleResult> {
    private static final Tuple DEFAULT = GuardrailsUtil.getTuple((Map<String, Object>)ImmutableMap.of((Object)"space_size", (Object)BigDecimal.ZERO, (Object)"space_id", (Object)"", (Object)"space_status", (Object)""));

    public MaxSizePersonalSpaceQuery(EntityManagerTemplate tmpl) {
        super(QueryIds.MAX_SIZE_PERSONAL_SPACE, tmpl, "select cast(sum(cp.longval)/1024/1024/1024 as big_decimal) as space_size, max(s.id) as space_id, s.type as space_type, s.status as space_status from Space as s inner join Content as c on s.id = c.space.id left outer join ContentProperty as cp on c.id = cp.content where s.type = 'personal' and s.status = 'CURRENT' and s.key is not null and s.name is not null and s.type is not null and s.status is not null group by s.key, s.name, s.type, s.status order by space_size desc");
    }

    @Override
    public TupleResult execute() {
        Optional<Tuple> result = this.prepareQuery(Tuple.class).stream().filter(t -> t.get(0) != null).findFirst();
        return new TupleResult(result.orElse(DEFAULT));
    }
}

