/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.CommonBeanConfiguration;
import com.atlassian.migration.agent.newexport.TemplatedQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.guardrails.queries.GuardrailsQueries;
import com.atlassian.migration.agent.store.guardrails.queries.ListQuery;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.impl.DialectResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Import(value={CommonBeanConfiguration.class})
@Configuration
public class GuardrailsListQueriesConfiguration {
    @Autowired
    EntityManagerTemplate tmpl;
    @Autowired
    DialectResolver dialectResolver;

    @Bean
    public ListQuery currentAttPerPageQuery() {
        return new ListQuery(QueryIds.CURRENT_ATT_PER_PAGE, this.tmpl, "select content.container.id as page_id, count(*) as attachment_count from Content content where content.type = 'ATTACHMENT'  and content.container.id in    (select c.id from Content c where c.type in ('PAGE', 'BLOGPOST') and c.previousVersion is null and c.status in ('current', 'draft'))    and content.previousVersion is null    and content.status = 'current' group by content.container.id order by attachment_count DESC", AbstractQuery.QueryBuilderOptions.max(100));
    }

    public ListQuery findRecentlyUsedSpacesQuery() {
        return this.create(QueryIds.RECENTLY_USED_SPACES, "select s.key as spacekey, s.status as spacestatus, s.type as spacetype, count(*) as numberOfContent, (select count(*) from Content nc where nc.spaceId = s.id and nc.lastModDate > current_date - 180) as spaceLastModified, (select count(s) from s where s.key in (select spaceKey from RecentlyViewed group by contentId, spaceKey having max(lastViewDate) > current_date - 180)) as numberOfUniqueUsersVisited FROM Content c join Space s on c.spaceId = s.id where c.type = 'PAGE' and c.previousVersion is null and c.status = 'current' group by s.id, s.key, s.name, s.status, s.type");
    }

    @Bean
    public ListQuery sizeOfDBQuery() {
        return this.create(QueryIds.SIZE_OF_DB, GuardrailsQueries.SIZE_OF_DB_QUERY);
    }

    @Bean
    public ListQuery groupsPerUserQuery() {
        return new ListQuery(QueryIds.GROUPS_PER_USER, this.tmpl, "select count(parent) as number_of_groups, child as user_id from CrowdMembership cm group by child order by number_of_groups desc", AbstractQuery.QueryBuilderOptions.max(100));
    }

    @Bean
    public ListQuery totalBlogpostsQuery() {
        return this.create(QueryIds.TOTAL_BLOGPOSTS, "select status as status, count(*) as blogpost_count from Content where previousVersion is null and type = 'BLOGPOST' group by status");
    }

    @Bean
    public ListQuery sizeOfTablesQuery() {
        return this.create(QueryIds.SIZE_OF_TABLES, GuardrailsQueries.SIZE_OF_TABLES_QUERY);
    }

    @Bean
    public ListQuery numberOfSpacesPerSpaceTypeQuery() {
        return this.create(QueryIds.NUMBER_OF_SPACES_PER_SPACETYPE, "select s.type as type, count(*) as TOTAL_SPACE_TYPE from Space s where s.type is not null group by s.type");
    }

    @Bean
    public ListQuery numberOfSpacesQuery() {
        return this.create(QueryIds.NUMBER_OF_SPACES, "select status as status, count(*) as space_count from Space group by status");
    }

    @Bean
    public ListQuery totalPagesQuery() {
        return this.create(QueryIds.TOTAL_PAGES, "select status as status, count(*) as page_count from Content where previousVersion is null and type = 'PAGE' group by status");
    }

    @Bean
    public ListQuery personalSpacesForInactiveUsersQuery() {
        return this.create(QueryIds.PERSONAL_SPACES_INACTIVE_USERS, "select s.id as space_id from Space s join UserMapping u ON s.creator = u.userKey join CrowdUser c ON c.lowerUsername = u.lowerUsername where s.key like '%~%' AND c.active = 'F'");
    }

    @Bean
    public ListQuery totalAttachmentsPerPageQuery() {
        return new ListQuery(QueryIds.TOTAL_ATTACHMENTS_PER_PAGE, this.tmpl, "select content.container.id as page_id, count(*) as attachment_count, content.status as attachment_status from Content content where content.type = 'ATTACHMENT' and content.container.id in (select c.id from Content c where c.type in ('PAGE', 'BLOGPOST') and c.status in ('current', 'draft') and c.previousVersion is null) and content.previousVersion is null group by content.container.id, content.status order by attachment_count desc", AbstractQuery.QueryBuilderOptions.max(100));
    }

    @Bean
    public ListQuery totalAttachmentsPerSpaceQuery() {
        return new ListQuery(QueryIds.TOTAL_ATTACHMENTS_PER_SPACE, this.tmpl, "select content.spaceId as space_id, count(content.id) as attachment_count \n from Content content \n where content.type = 'ATTACHMENT'\n group by content.spaceId \n order by attachment_count DESC", AbstractQuery.QueryBuilderOptions.max(100));
    }

    @Bean
    public ListQuery totalPagesPerVersionQuery() {
        return new ListQuery(QueryIds.TOTAL_PAGES_PER_VERSION, this.tmpl, "select version as version, count(*) as page_count from Content where type in ('PAGE', 'BLOGPOST') and status in ('current', 'draft') group by version order by page_count desc", AbstractQuery.QueryBuilderOptions.max(100));
    }

    private ListQuery create(QueryIds queryId, String query) {
        return new ListQuery(queryId, this.tmpl, query);
    }

    private ListQuery create(QueryIds queryId, TemplatedQuery query) {
        return new ListQuery(queryId, this.tmpl, this.query(query), true);
    }

    private String query(TemplatedQuery query) {
        return query.query(this.dialectResolver.getDbType());
    }
}

