/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessment;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MacrosAssessmentPerSpace {
    @JsonProperty
    private final long spaceId;
    @JsonProperty
    private final Set<MacroAssessment> notAvailableMacros;
    @JsonProperty
    private final Set<MacroAssessment> differentMacros;
    @JsonProperty
    private final long uniqueContentCount;

    private static long uniqueContentCount(Set<MacroAssessment> notAvailableMacros, Set<MacroAssessment> differentMacros) {
        return Stream.concat(notAvailableMacros.stream(), differentMacros.stream()).flatMap(macroAssessment -> macroAssessment.getContentUrls().stream()).distinct().count();
    }

    @JsonProperty
    public int uniqueMacrosCount() {
        return this.notAvailableMacros.size() + this.differentMacros.size();
    }

    @JsonCreator
    public MacrosAssessmentPerSpace(@JsonProperty(value="spaceId") long spaceId, @JsonProperty(value="notAvailableMacros") Set<MacroAssessment> notAvailableMacros, @JsonProperty(value="differentMacros") Set<MacroAssessment> differentMacros) {
        this.spaceId = spaceId;
        this.notAvailableMacros = notAvailableMacros;
        this.differentMacros = differentMacros;
        this.uniqueContentCount = MacrosAssessmentPerSpace.uniqueContentCount(notAvailableMacros, differentMacros);
    }

    @Generated
    public long getSpaceId() {
        return this.spaceId;
    }

    @Generated
    public Set<MacroAssessment> getNotAvailableMacros() {
        return this.notAvailableMacros;
    }

    @Generated
    public Set<MacroAssessment> getDifferentMacros() {
        return this.differentMacros;
    }

    @Generated
    public long getUniqueContentCount() {
        return this.uniqueContentCount;
    }

    @Generated
    public String toString() {
        return "MacrosAssessmentPerSpace(spaceId=" + this.getSpaceId() + ", notAvailableMacros=" + this.getNotAvailableMacros() + ", differentMacros=" + this.getDifferentMacros() + ", uniqueContentCount=" + this.getUniqueContentCount() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MacrosAssessmentPerSpace)) {
            return false;
        }
        MacrosAssessmentPerSpace other = (MacrosAssessmentPerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSpaceId() != other.getSpaceId()) {
            return false;
        }
        Set<MacroAssessment> this$notAvailableMacros = this.getNotAvailableMacros();
        Set<MacroAssessment> other$notAvailableMacros = other.getNotAvailableMacros();
        if (this$notAvailableMacros == null ? other$notAvailableMacros != null : !((Object)this$notAvailableMacros).equals(other$notAvailableMacros)) {
            return false;
        }
        Set<MacroAssessment> this$differentMacros = this.getDifferentMacros();
        Set<MacroAssessment> other$differentMacros = other.getDifferentMacros();
        if (this$differentMacros == null ? other$differentMacros != null : !((Object)this$differentMacros).equals(other$differentMacros)) {
            return false;
        }
        return this.getUniqueContentCount() == other.getUniqueContentCount();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MacrosAssessmentPerSpace;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $spaceId = this.getSpaceId();
        result = result * 59 + (int)($spaceId >>> 32 ^ $spaceId);
        Set<MacroAssessment> $notAvailableMacros = this.getNotAvailableMacros();
        result = result * 59 + ($notAvailableMacros == null ? 43 : ((Object)$notAvailableMacros).hashCode());
        Set<MacroAssessment> $differentMacros = this.getDifferentMacros();
        result = result * 59 + ($differentMacros == null ? 43 : ((Object)$differentMacros).hashCode());
        long $uniqueContentCount = this.getUniqueContentCount();
        result = result * 59 + (int)($uniqueContentCount >>> 32 ^ $uniqueContentCount);
        return result;
    }
}

