/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.results;

import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.migration.agent.store.guardrails.GuardrailsTupleElement;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.results.AbstractResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import lombok.Generated;

public class TablesPerPageQueryResult
extends AbstractResult {
    private static final int TOPK = 50;
    @JsonProperty
    private List<Tuple> results;

    public TablesPerPageQueryResult(List<Tuple> results, RecentlyViewedManager recentlyViewedManager) {
        List<Tuple> sortedResults = GuardrailsUtil.sorted(results, GuardrailsUtil.tupleComparator(1, Integer.class).reversed());
        List topKPageIds = sortedResults.stream().map(tuple -> (Long)tuple.get(0, Long.class)).limit(50L).collect(Collectors.toList());
        Map recentViewers = recentlyViewedManager.getRecentViewers(topKPageIds);
        this.results = new ArrayList<Tuple>(sortedResults.size());
        for (Tuple tuple2 : sortedResults) {
            Long pageId = (Long)tuple2.get(0, Long.class);
            int numberOfViews = ((Collection)recentViewers.getOrDefault(pageId, Collections.emptyList())).size();
            this.results.add(GuardrailsUtil.getTuple(new GuardrailsTupleElement<Long>("page_id", pageId, Long.class), new GuardrailsTupleElement<Integer>("count", (Integer)tuple2.get(1, Integer.class), Integer.class), new GuardrailsTupleElement<Integer>("number_of_views", numberOfViews, Integer.class), new GuardrailsTupleElement<Integer>("page_edit_frequency", (Integer)tuple2.get(2, Integer.class), Integer.class)));
        }
    }

    @Override
    public String generateResult() {
        return GuardrailsUtil.formatPerPageDistributionResult(this.results, 50);
    }

    @Generated
    public List<Tuple> getResults() {
        return this.results;
    }

    @JsonProperty
    @Generated
    public void setResults(List<Tuple> results) {
        this.results = results;
    }
}

