/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.CommonBeanConfiguration;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.guardrails.queries.CountQuery;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Import(value={CommonBeanConfiguration.class})
@Configuration
public class GuardrailsCountQueriesConfiguration {
    private static final String ACTIVE = "active";
    @Autowired
    EntityManagerTemplate tmpl;

    @Bean
    public CountQuery allGroups() {
        return this.create(QueryIds.GROUP, "select count(distinct cg.id) from CrowdGroup as cg");
    }

    @Bean
    public CountQuery baseUsers() {
        return this.create(QueryIds.BASE_USERS, "select count(cu.lowerUsername) from CrowdUser cu where cu.active=:active", AbstractQuery.QueryBuilderOptions.param(ACTIVE, true));
    }

    @Bean
    public CountQuery activeUsers() {
        return this.create(QueryIds.ACTIVE_USERS, "select count(cu.id) from CrowdUser cu where cu.active=:active", AbstractQuery.QueryBuilderOptions.param(ACTIVE, true));
    }

    @Bean
    public CountQuery allUsers() {
        return this.create(QueryIds.ALL_USERS, "select count(cu.id) from CrowdUser cu");
    }

    @Bean
    public CountQuery inactiveUsers() {
        return this.create(QueryIds.INACTIVE_USERS, "select count(cu.lowerUsername) from CrowdUser cu where cu.active=:active", AbstractQuery.QueryBuilderOptions.param(ACTIVE, false));
    }

    @Bean
    public CountQuery numberOfGroups() {
        return this.create(QueryIds.NUMBER_OF_GROUPS, "select count(*) from CrowdGroup where active =:active", AbstractQuery.QueryBuilderOptions.param(ACTIVE, true));
    }

    @Bean
    public CountQuery totalAttachmentsQuery() {
        return this.create(QueryIds.TOTAL_ATTACHMENTS, "select count(co.id) from Content co where co.type=:type", AbstractQuery.QueryBuilderOptions.param("type", "ATTACHMENT"));
    }

    @Bean
    public CountQuery pagesWithRestrictions() {
        return this.create(QueryIds.PAGES_WITH_RESTRICTIONS, "select count(distinct(cps.contentId)) from ContentPermSet as cps inner join Content as c on c.id = cps.contentId where c.status in ('current', 'draft')");
    }

    private CountQuery create(QueryIds queryId, String query) {
        return new CountQuery(queryId, this.tmpl, query);
    }

    private CountQuery create(QueryIds queryId, String query, AbstractQuery.QueryBuilderOptions queryOptions) {
        return new CountQuery(queryId, this.tmpl, query, queryOptions);
    }
}

