/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessment;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.macro.MacroInformationSupplier;
import com.atlassian.migration.agent.service.guardrails.macro.MacroResultSetConverter;
import com.atlassian.migration.agent.service.guardrails.macro.MacroStatus;
import com.atlassian.migration.agent.service.guardrails.macro.MacroTuple;
import com.atlassian.migration.agent.service.guardrails.macro.MacrosAssessmentPerSpace;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

class DefaultMacroResultSetConverter
implements MacroResultSetConverter {
    public static final String BASE_PATH = "%s";
    public static final String PAGE_PATH = "%s/pages/viewpage.action?pageId=%d";
    public static final String COMMENT_PATH = "%s/pages/viewpage.action?pageId=%d&focusedCommentId=%d#comment-%d";
    private final MacroInformationSupplier macroInformationSupplier;
    private final SystemInformationService sysInfoService;

    @Override
    public MacroAssessmentResult convert(Set<MacroTuple> macroTuple) {
        Map<Long, Set<MacroTuple>> groupedBySpace = this.groupBySpace(macroTuple);
        Set<MacrosAssessmentPerSpace> macrosAssessmentPerSpaces = this.getMacrosAssessmentPerSpace(groupedBySpace);
        return new MacroAssessmentResult(macrosAssessmentPerSpaces, this.getUniqueContentCount(macroTuple), this.getUniqueMacroCount(macroTuple));
    }

    private Set<MacrosAssessmentPerSpace> getMacrosAssessmentPerSpace(Map<Long, Set<MacroTuple>> groupedBySpace) {
        String baseUrl = this.sysInfoService.getConfluenceInfo().getBaseUrl();
        HashSet<MacrosAssessmentPerSpace> macrosAssessmentPerSpace = new HashSet<MacrosAssessmentPerSpace>();
        for (Map.Entry<Long, Set<MacroTuple>> entry : groupedBySpace.entrySet()) {
            Optional<MacrosAssessmentPerSpace> macrosAssessmentForSpace = this.getMacrosAssessmentForSpace(entry.getKey(), entry.getValue(), baseUrl);
            macrosAssessmentForSpace.ifPresent(macrosAssessmentPerSpace::add);
        }
        return macrosAssessmentPerSpace;
    }

    private Optional<MacrosAssessmentPerSpace> getMacrosAssessmentForSpace(long spaceId, Set<MacroTuple> macros, String baseUrl) {
        Map byStatus = macros.stream().collect(Collectors.groupingBy(this::getMacroStatus, Collectors.toSet()));
        Set<MacroAssessment> unavailable = this.toMacroAssessment(byStatus.getOrDefault((Object)MacroStatus.UNAVAILABLE, Collections.emptySet()), baseUrl);
        Set<MacroAssessment> different = this.toMacroAssessment(byStatus.getOrDefault((Object)MacroStatus.DIFFERENT, Collections.emptySet()), baseUrl);
        return unavailable.isEmpty() && different.isEmpty() ? Optional.empty() : Optional.of(new MacrosAssessmentPerSpace(spaceId, unavailable, different));
    }

    private Set<MacroAssessment> toMacroAssessment(Set<MacroTuple> results, String baseUrl) {
        Map macroOccurrences = results.stream().collect(Collectors.groupingBy(MacroTuple::getMacro, Collectors.mapping(assessment -> this.createContentUrl((MacroTuple)assessment, baseUrl), Collectors.toSet())));
        return macroOccurrences.entrySet().stream().map(entry -> new MacroAssessment((String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toSet());
    }

    private String createContentUrl(MacroTuple macroTuple, String baseUrl) {
        if (macroTuple.getContentType().equalsIgnoreCase("comment")) {
            return String.format(COMMENT_PATH, baseUrl, macroTuple.getPageId(), macroTuple.getContentId(), macroTuple.getContentId());
        }
        return String.format(PAGE_PATH, baseUrl, macroTuple.getContentId());
    }

    private long getUniqueMacroCount(Set<MacroTuple> macroOccurrences) {
        return macroOccurrences.stream().map(MacroTuple::getMacro).distinct().count();
    }

    private long getUniqueContentCount(Set<MacroTuple> macroOccurrences) {
        return macroOccurrences.stream().map(MacroTuple::getContentId).distinct().count();
    }

    private Map<Long, Set<MacroTuple>> groupBySpace(Collection<MacroTuple> macroOccurrences) {
        return macroOccurrences.stream().collect(Collectors.groupingBy(MacroTuple::getSpaceId, Collectors.toSet()));
    }

    private MacroStatus getMacroStatus(MacroTuple macroTuple) {
        if (macroTuple.getContentType().equalsIgnoreCase("comment")) {
            return MacroStatus.UNAVAILABLE;
        }
        return this.macroInformationSupplier.getMacroStatus(macroTuple.getMacro());
    }

    @Generated
    public DefaultMacroResultSetConverter(MacroInformationSupplier macroInformationSupplier, SystemInformationService sysInfoService) {
        this.macroInformationSupplier = macroInformationSupplier;
        this.sysInfoService = sysInfoService;
    }
}

