/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.confluence.cluster.ClusterInformation;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.DatabaseInfo;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.InstanceStats;
import com.atlassian.migration.agent.model.stats.ServerStats;
import com.atlassian.migration.agent.service.NetworkStatisticsService;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventConstants;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.encryption.EncryptionConfigHandler;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.sal.api.license.LicenseHandler;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.VisibleForTesting;

public class ServerMetadataAnalyticsEventBuilder {
    private final SystemInformationService systemInformationService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final PluginMetadataManager pluginMetadataManager;
    private final ClusterManager clusterManager;
    private final PluginVersionManager pluginVersionManager;
    private final EncryptionConfigHandler encryptionConfigHandler;
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final StatisticsService statisticsService;
    private final LicenseHandler licenseHandler;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public ServerMetadataAnalyticsEventBuilder(SystemInformationService systemInformationService, CrowdDirectoryService crowdDirectoryService, PluginMetadataManager pluginMetadataManager, ClusterManager clusterManager, PluginVersionManager pluginVersionManager, EncryptionConfigHandler encryptionConfigHandler, SENSupplier senSupplier, StatisticsService statisticsService, LicenseHandler licenseHandler, MigrationAgentConfiguration migrationAgentConfiguration, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this(systemInformationService, crowdDirectoryService, pluginMetadataManager, clusterManager, pluginVersionManager, encryptionConfigHandler, senSupplier, Instant::now, statisticsService, licenseHandler, migrationAgentConfiguration, analyticsEventBuilderUtil);
    }

    @VisibleForTesting
    ServerMetadataAnalyticsEventBuilder(SystemInformationService systemInformationService, CrowdDirectoryService crowdDirectoryService, PluginMetadataManager pluginMetadataManager, ClusterManager clusterManager, PluginVersionManager pluginVersionManager, EncryptionConfigHandler encryptionConfigHandler, SENSupplier senSupplier, Supplier<Instant> instantSupplier, StatisticsService statisticsService, LicenseHandler licenseHandler, MigrationAgentConfiguration migrationAgentConfiguration, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.systemInformationService = systemInformationService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.pluginMetadataManager = pluginMetadataManager;
        this.clusterManager = clusterManager;
        this.pluginVersionManager = pluginVersionManager;
        this.encryptionConfigHandler = encryptionConfigHandler;
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.statisticsService = statisticsService;
        this.licenseHandler = licenseHandler;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    public EventDto buildCompletedInstanceAnalysisAnalyticsEvent(ServerStats serverStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        DatabaseInfo databaseInfo = this.systemInformationService.getDatabaseInfo();
        attributes.put((Object)"database", (Object)ImmutableMap.of((Object)"type", (Object)databaseInfo.getName(), (Object)"version", (Object)databaseInfo.getVersion()));
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        attributes.put((Object)"apps", (Object)confluenceInfo.getEnabledPlugins().stream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).map(Plugin::getKey).collect(Collectors.toCollection(LinkedList::new)));
        List directories = this.crowdDirectoryService.findAllDirectories();
        boolean ldap = directories.stream().filter(Directory::isActive).map(Directory::getType).anyMatch(AnalyticsEventConstants.LDAP_DIRECTORY_TYPES::contains);
        attributes.put((Object)"LDAP", (Object)ldap);
        attributes.put((Object)"estimatedTime", (Object)Long.toString(serverStats.getTotalSpaceMigrationTime().plus(serverStats.getTotalUserGroupMigrationTime()).plus(MigrationTimeEstimationUtils.getBaseMigrationTime()).getSeconds()));
        attributes.put((Object)"bandwidthKBS", (Object)(serverStats.getBandwidthKBS() == NetworkStatisticsService.getUncalculatedBandwidthKBPS() ? "" : Long.toString(serverStats.getBandwidthKBS())));
        InstanceStats instanceStats = serverStats.getInstanceStats();
        attributes.put((Object)"version", (Object)instanceStats.getVersion());
        attributes.put((Object)"numberOfSpaces", (Object)Long.toString(instanceStats.getNumberOfSpaces()));
        attributes.put((Object)"numberOfUsers", (Object)Long.toString(instanceStats.getNumberOfUsers()));
        attributes.put((Object)"numberOfGroups", (Object)Long.toString(instanceStats.getNumberOfGroups()));
        ContentSummary contentSummary = serverStats.getContentSummary();
        attributes.put((Object)"totalAttachmentsSize", (Object)Long.toString(contentSummary.getAttachments().getTotalSize() != null ? contentSummary.getAttachments().getTotalSize() : 0L));
        attributes.put((Object)"numberOfPages", (Object)Long.toString(contentSummary.getNumberOfPages() != null ? contentSummary.getNumberOfPages() : 0L));
        attributes.put((Object)"numberOfBlogs", (Object)Long.toString(contentSummary.getNumberOfBlogs() != null ? contentSummary.getNumberOfBlogs() : 0L));
        attributes.put((Object)"numberOfTeamCalendars", (Object)Long.toString(contentSummary.getNumberOfTeamCalendars() != null ? contentSummary.getNumberOfTeamCalendars() : 0L));
        ClusterInformation clusterInformation = this.clusterManager.getClusterInformation();
        attributes.put((Object)"clustered", (Object)this.clusterManager.isClustered());
        attributes.put((Object)"numberOfNodes", (Object)Integer.toString(clusterInformation.getMemberCount()));
        attributes.put((Object)"configuredHeapSize", (Object)Long.toString(configuredHeapSize));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"encryptionKeyLocation", (Object)this.encryptionConfigHandler.getKeyLocationFromConfig());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).email(confluenceUser == null ? null : confluenceUser.getEmail())).sen(this.senSupplier.get())).action("completed")).actionSubject("instanceAnalysis")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceStatisticCalculationBatchStepExecutionErrorEvent(String jobId, String executionId, String batchId, String batchStep, int batchSize, boolean includeHistoricalData, Exception e, String spaceId) {
        String calculationExceptionMessage = e == null ? "" : e.getMessage().trim();
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getSpaceStatisticBuilderWithCommonAttributes();
        attributes.put((Object)"jobId", (Object)jobId);
        attributes.put((Object)"executionId", (Object)executionId);
        attributes.put((Object)"batchSize", (Object)batchSize);
        attributes.put((Object)"includeHistoricalData", (Object)includeHistoricalData);
        attributes.put((Object)"spaceId", (Object)(spaceId == null ? "" : spaceId));
        attributes.put((Object)"error", (Object)calculationExceptionMessage.substring(0, Math.min(calculationExceptionMessage.length(), this.migrationAgentConfiguration.getAnalyticsSenderMaxEventLength() / 2)));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).sen(this.senSupplier.get())).source("spaceStatisticCalculation")).action("failed")).actionSubject(batchStep)).contextContainer("batch", batchId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceStatisticCalculationBatchExecutionCompletedEvent(String jobId, String executionId, String batchId, int batchSize, boolean includeHistoricalData, boolean overallSuccess, Map<String, Boolean> executionStepsSuccess, int errorCount, long startTimeEpochMilli, long readEndTimeEpochMilli, long endTimeEpochMilli) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getSpaceStatisticBuilderWithCommonAttributes();
        attributes.put((Object)"jobId", (Object)jobId);
        attributes.put((Object)"executionId", (Object)executionId);
        attributes.put((Object)"batchSize", (Object)batchSize);
        attributes.put((Object)"includeHistoricalData", (Object)includeHistoricalData);
        attributes.put((Object)"status", (Object)(overallSuccess ? "success" : "fail"));
        attributes.put((Object)"executionStepsSuccess", executionStepsSuccess);
        attributes.put((Object)"errorCount", (Object)errorCount);
        attributes.put((Object)"startTime", (Object)Instant.ofEpochMilli(startTimeEpochMilli));
        attributes.put((Object)"stopTime", (Object)Instant.ofEpochMilli(endTimeEpochMilli));
        attributes.put((Object)"totalTimeTaken", (Object)(endTimeEpochMilli - startTimeEpochMilli));
        attributes.put((Object)"timeTakenToCalculate", (Object)(readEndTimeEpochMilli - startTimeEpochMilli));
        attributes.put((Object)"timeTakenToStore", (Object)(endTimeEpochMilli - readEndTimeEpochMilli));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).sen(this.senSupplier.get())).source("spaceStatisticCalculation")).action("completed")).actionSubject("batchExecution")).contextContainer("batch", batchId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceStatisticCalculationJobExecutionCompletedEvent(String jobId, String executionId, int spaceCount, int numberOfBatches, int batchSizeLimit, boolean includeHistoricalData, long startTimeEpocMilli, long waitStartTimeEpocMilli, long endTimeEpocMilli) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getSpaceStatisticBuilderWithCommonAttributes();
        attributes.put((Object)"jobId", (Object)jobId);
        attributes.put((Object)"numberOfSpaces", (Object)spaceCount);
        attributes.put((Object)"numberOfBatches", (Object)numberOfBatches);
        attributes.put((Object)"batchSizeLimit", (Object)batchSizeLimit);
        attributes.put((Object)"includeHistoricalData", (Object)includeHistoricalData);
        attributes.put((Object)"startTime", (Object)Instant.ofEpochMilli(startTimeEpocMilli));
        attributes.put((Object)"stopTime", (Object)Instant.ofEpochMilli(endTimeEpocMilli));
        attributes.put((Object)"totalTimeTaken", (Object)(endTimeEpocMilli - startTimeEpocMilli));
        attributes.put((Object)"timeTakenToSubmit", (Object)(waitStartTimeEpocMilli - startTimeEpocMilli));
        attributes.put((Object)"timeTakenToExecute", (Object)(endTimeEpocMilli - waitStartTimeEpocMilli));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).sen(this.senSupplier.get())).source("spaceStatisticCalculation")).action("completed")).actionSubject("jobExecution")).contextContainer("execution", executionId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceMetadataEvent(String cloudId, int batchSize, int totalSpaceCount, List<Exception> exceptionList) {
        ServerStats serverStats = this.statisticsService.loadServerStatistics();
        String action = exceptionList.isEmpty() ? "success" : "failed";
        GenericOperationalEvent.Builder builder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).source("CCMA")).cloudId(cloudId)).sen(this.senSupplier.get())).pluginVersion(this.pluginVersionManager.getPluginVersion())).action(action)).actionSubject("spaceMetadataCreation")).addAttribute("batchSize", (Object)batchSize)).addAttribute("totalSpaceCount", (Object)totalSpaceCount)).addAttribute("productVersion", (Object)serverStats.getInstanceStats().getVersion())).addAttribute("serverId", (Object)this.licenseHandler.getServerId());
        if (action.equals("failed")) {
            ((GenericOperationalEvent.Builder)builder.addAttribute("failureBatchCount", (Object)exceptionList.size())).addAttribute("error", exceptionList.stream().collect(Collectors.groupingBy(e -> e.getClass().getCanonicalName(), Collectors.counting())));
        }
        return builder.build();
    }

    public EventDto buildServerMetadataEvent(String cloudId, Optional<Exception> optionalException) {
        ServerStats serverStats = this.statisticsService.loadServerStatistics();
        String action = optionalException.isPresent() ? "failed" : "success";
        GenericOperationalEvent.Builder builder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).source("CCMA")).cloudId(cloudId)).sen(this.senSupplier.get())).pluginVersion(this.pluginVersionManager.getPluginVersion())).action(action)).actionSubject("serverMetadataCreation")).addAttribute("productVersion", (Object)serverStats.getInstanceStats().getVersion())).addAttribute("serverId", (Object)this.licenseHandler.getServerId());
        optionalException.ifPresent(e -> {
            GenericOperationalEvent.Builder cfr_ignored_0 = (GenericOperationalEvent.Builder)builder.addAttribute("error", (Object)e.getClass().getCanonicalName());
        });
        return builder.build();
    }
}

