/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mma.service;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.SpaceStatistic;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.mma.model.ServerInstanceDTO;
import com.atlassian.migration.agent.mma.model.SpaceMetadata;
import com.atlassian.migration.agent.mma.model.SpaceMetadataDTO;
import com.atlassian.migration.agent.mma.model.processor.MetadataBatch;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.agent.service.impl.DefaultSpaceStatistics;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.agent.store.CloudSiteStore;
import com.atlassian.migration.agent.store.impl.SpaceStore;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class MigrationMetadataAggregatorService {
    private final SystemInformationService sysInfoService;
    private final PluginVersionManager pluginVersionManager;
    private final LicenseHandler licenseHandler;
    private final EnterpriseGatekeeperClient enterpriseGatekeeperClient;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final AnalyticsEventService analyticsEventService;
    private final SpaceStore spaceStore;
    private final CloudSiteStore cloudSiteStore;
    private final EventPublisher eventPublisher;
    private final DefaultSpaceStatistics defaultSpaceStatistics;
    private static final Logger log = ContextLoggerFactory.getLogger(MigrationMetadataAggregatorService.class);
    private static final String CONFLUENCE_SERVER_PRODUCT_KEY = "confluence-server";
    static final int BATCH_SIZE_SPACE_METADATA = 1000;

    public MigrationMetadataAggregatorService(SystemInformationService sysInfoService, PluginVersionManager pluginVersionManager, LicenseHandler licenseHandler, EnterpriseGatekeeperClient enterpriseGatekeeperClient, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SpaceStore spaceStore, CloudSiteStore cloudSiteStore, AnalyticsEventBuilder analyticsEventBuilder, AnalyticsEventService analyticsEventService, EventPublisher eventPublisher, DefaultSpaceStatistics defaultSpaceStatistics) {
        this.sysInfoService = sysInfoService;
        this.pluginVersionManager = pluginVersionManager;
        this.licenseHandler = licenseHandler;
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.spaceStore = spaceStore;
        this.cloudSiteStore = cloudSiteStore;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.analyticsEventService = analyticsEventService;
        this.eventPublisher = eventPublisher;
        this.defaultSpaceStatistics = defaultSpaceStatistics;
    }

    @PostConstruct
    void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    void cleanup() {
        this.eventPublisher.unregister((Object)this);
    }

    public void sendServerInstanceMetadataToMMAForAllCloudSites() {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.createServerInstanceCloudSitePairInMMA(site.getContainerToken(), site.getCloudId()));
    }

    public JsonElement createServerInstanceCloudSitePairInMMA(String containerToken, String cloudId) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return null;
        }
        ServerInstanceDTO serverInstance = this.mapServerInstanceDto(cloudId);
        MetadataBatch<ServerInstanceDTO> batchServerInstanceDTO = new MetadataBatch<ServerInstanceDTO>(serverInstance);
        try {
            JsonElement response = this.enterpriseGatekeeperClient.sendServerInstanceInfoToMigrationMetadataAggregator(containerToken, cloudId, batchServerInstanceDTO);
            log.info("Sent request to MMA for Server Instance\n[{}]", batchServerInstanceDTO);
            EventDto analyticEvent = this.analyticsEventBuilder.buildServerMetadataEvent(cloudId, Optional.empty());
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
            return response;
        }
        catch (Exception e) {
            EventDto analyticEvent = this.analyticsEventBuilder.buildServerMetadataEvent(cloudId, Optional.of(e));
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
            throw e;
        }
    }

    private ServerInstanceDTO mapServerInstanceDto(String cloudId) {
        return ServerInstanceDTO.builder().cloudId(cloudId).serverId(this.sysInfoService.getConfluenceInfo().getServerId()).supportEntitlementNumber(this.sysInfoService.getConfluenceInfo().getSupportEntitlementNumber()).productVersion(this.sysInfoService.getConfluenceInfo().getVersion()).serverBaseUrl(this.sysInfoService.getConfluenceInfo().getBaseUrl()).cmaVersion(this.pluginVersionManager.getPluginVersion()).organizationName(this.getOrganisationName()).productKey(CONFLUENCE_SERVER_PRODUCT_KEY).build();
    }

    private String getOrganisationName() {
        return this.licenseHandler.getAllProductLicenses().stream().map(BaseLicenseDetails::getOrganisationName).findFirst().orElse(null);
    }

    public void sendSpaceMetadataToMMAForAllCloudSites() {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.sendSpaceMetadataToMMA(site.getContainerToken(), site.getCloudId(), serverId));
    }

    public void sendSpaceMetadataToMMA(String containerToken, String cloudId, String serverId) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        this.enterpriseGatekeeperClient.deleteSpaceMetadataFromMigrationMetadataAggregator(containerToken, cloudId, serverId);
        log.info("Deleted Spaces in MMA for Cloud/Server ID pair [{}/{}] ! Ready to refresh Space state", (Object)cloudId, (Object)serverId);
        List spaceMetadata = this.spaceStore.getSpaceMetadata().stream().map(s -> new SpaceMetadataDTO((SpaceMetadata)s, cloudId, serverId)).collect(Collectors.toList());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        List responses = Lists.partition(spaceMetadata, (int)1000).stream().map(spaceMetadataChunk -> {
            try {
                return this.enterpriseGatekeeperClient.sendSpaceMetadataToMigrationMetadataAggregator(containerToken, cloudId, new MetadataBatch<SpaceMetadataDTO>((List<SpaceMetadataDTO>)spaceMetadataChunk));
            }
            catch (Exception e) {
                log.error("There was an error sending a batch of metadata to MMA: {}", (Object)e.getMessage());
                exceptions.add(e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        EventDto analyticEvent = this.analyticsEventBuilder.buildSpaceMetadataEvent(cloudId, 1000, spaceMetadata.size(), exceptions);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        log.info("Emitted latest Space metadata to MMA. Sent [{}] spaces in [{}] successful batches", (Object)spaceMetadata.size(), (Object)responses.size());
    }

    @EventListener
    public void handleSpaceCreatedEvent(SpaceCreateEvent event) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        SpaceStatistic defaultMetadata = this.defaultSpaceStatistics.createDefaultStats(event.getSpace().getId(), event.getSpace().getLastModificationDate());
        SpaceMetadata changedSpaceMetadata = new SpaceMetadata(event.getSpace().getId(), event.getSpace().getKey(), event.getSpace().getName(), event.getSpace().getType(), defaultMetadata.getSumOfPageBlogDraftCount(), defaultMetadata.getAttachmentSize(), defaultMetadata.getAttachmentCount(), defaultMetadata.getEstimatedMigrationTime(), new Timestamp(event.getSpace().getLastModificationDate().getTime()));
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.sendSpaceMetadataToMMAForSingleEntity(changedSpaceMetadata, site.getContainerToken(), site.getCloudId()));
    }

    public void sendSpaceMetadataToMMAForSingleEntity(SpaceMetadata changedSpaceMetadata, String containerToken, String cloudId) {
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        SpaceMetadataDTO metadataToSend = new SpaceMetadataDTO(changedSpaceMetadata, cloudId, serverId);
        try {
            this.enterpriseGatekeeperClient.sendSpaceMetadataToMigrationMetadataAggregatorForSingleEntity(containerToken, cloudId, serverId, metadataToSend);
        }
        catch (Exception e) {
            log.error("There was an error sending metadata for a new space to MMA: {}", (Object)e.getMessage());
        }
    }

    @EventListener
    public void handleSpaceRemoveEvent(SpaceRemoveEvent event) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        long spaceId = event.getSpace().getId();
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        nonFailingCloudSites.forEach(site -> this.deleteSpaceMetadataFromMMAForSingleEntity(site.getContainerToken(), site.getCloudId(), serverId, spaceId));
    }

    public void deleteSpaceMetadataFromMMAForSingleEntity(String containerToken, String cloudId, String serverId, long spaceId) {
        try {
            this.enterpriseGatekeeperClient.deleteSpaceMetadataFromMigrationMetadataAggregator(containerToken, cloudId, serverId, spaceId);
        }
        catch (Exception e) {
            log.error("There was an error deleting metadata in MMA for a deleted space: {}", (Object)e.getMessage());
        }
    }
}

