WRM.require('wr!external-libraries').done(function() {
  async function isBrowserMetricsEnabled() {
    AJS.log("Checking if browser metrics is enabled.");
    try {
      const data = await AJS.$.ajax({
        url: AJS.contextPath() + "/rest/migration/latest/browser-metrics/enabled",
        type: "GET",
      });
      return data.shouldCollect;
    } catch (error) {
      AJS.log("Ajax error response: " + error);
      return false;
    }
  }

// see https://developer.atlassian.com/server/jira/platform/jira-rest-api-examples/#calling-the-rest-api-from-an-app--quickview-inline-dialog-app
  AJS.toInit(async function () {
    if (await isBrowserMetricsEnabled()) {
      try {
        AJS.log("Collecting browser metrics data.");
        const connection = window.navigator.connection || {};
        const networkTelemetry = connection
            ? {
              effectiveType: connection.effectiveType,
              downlink: Number(connection.downlink),
              rtt: Number(connection.rtt),
            }
            : null;
        const browser = bowser.getParser(window.navigator.userAgent);
        const payload = {
          browserName:browser.getBrowserName(),
          browserVersion: browser.getBrowserVersion(),
          platform: window.navigator.platform,
          device: {
            processors: window.navigator.hardwareConcurrency,
            memory: window.navigator.deviceMemory,
          },
          network: networkTelemetry,
        };

        await AJS.$.ajax({
          url: AJS.contextPath() + "/rest/migration/latest/browser-metrics",
          type: "POST",
          data: JSON.stringify(payload),
          dataType: "json",
          contentType: "application/json",
        });

        AJS.log("Browser metrics data sent successfully");
      } catch (error) {
        AJS.log(
            `Error while sending browser metrics data: ${error.statusText}; With status: ${error.status}`
        );
      }
    } else {
      AJS.log(
          "Browser metrics is disabled or it was collected in the last 24h already."
      );
    }
  });
});


