/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.SpaceStatistic;
import com.atlassian.migration.agent.store.SpaceStatisticStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceStatisticStoreImpl
implements SpaceStatisticStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpaceStatisticStoreImpl.class);
    private final EntityManagerTemplate entityManagerTemplate;

    public SpaceStatisticStoreImpl(EntityManagerTemplate entityManagerTemplate) {
        this.entityManagerTemplate = entityManagerTemplate;
    }

    @Override
    public boolean isSpaceStatisticEmpty() {
        return this.entityManagerTemplate.query(Long.class, "select count(spaceStatistic.spaceId) from SpaceStatistic spaceStatistic").single() == 0L;
    }

    @Override
    public Optional<SpaceStatistic> getSpaceStatisticFor(long spaceId) {
        return this.entityManagerTemplate.query(SpaceStatistic.class, "select spaceStatistic from SpaceStatistic spaceStatistic where spaceStatistic.spaceId = :spaceId").param("spaceId", (Object)spaceId).first();
    }

    @Override
    public void upsert(SpaceStatistic spaceStatistic) {
        if (this.getSpaceStatisticFor(spaceStatistic.getSpaceId()).isPresent()) {
            this.entityManagerTemplate.merge(spaceStatistic);
        } else {
            this.entityManagerTemplate.persist(spaceStatistic);
        }
    }

    @Override
    public List<Long> getDeletedSpacesWithStatistics() {
        return this.entityManagerTemplate.query(Long.class, "select spaceStatistic.spaceId from SpaceStatistic spaceStatistic left join Space space on space.id = spaceStatistic.spaceId where space IS NULL").list();
    }

    @Override
    public void deleteSpaceStatisticsForSpacesWithIds(List<Long> spaceIds) {
        this.entityManagerTemplate.query("delete from SpaceStatistic where spaceId in :spaceIds").param("spaceIds", spaceIds).update();
    }
}

